/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.document.mongodb;

import com.mongodb.DB;
import com.mongodb.Mongo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.data.authentication.UserCredentials;
import org.springframework.data.document.mongodb.MongoDbFactory;
import org.springframework.data.document.mongodb.MongoDbUtils;
import org.springframework.util.Assert;

public class SimpleMongoDbFactory
implements MongoDbFactory {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Mongo mongo;
    private String databaseName;
    private String username;
    private String password;

    public SimpleMongoDbFactory(Mongo mongo, String databaseName) {
        Assert.notNull((Object)mongo, (String)"Mongo must not be null");
        Assert.hasText((String)databaseName, (String)"Database name must not be empty");
        this.mongo = mongo;
        this.databaseName = databaseName;
    }

    public SimpleMongoDbFactory(Mongo mongo, String databaseName, UserCredentials userCredentials) {
        this(mongo, databaseName);
        this.username = userCredentials.getUsername();
        this.password = userCredentials.getPassword();
    }

    public DB getDb() throws DataAccessException {
        Assert.notNull((Object)this.mongo, (String)"Mongo must not be null");
        Assert.hasText((String)this.databaseName, (String)"Database name must not be empty");
        return MongoDbUtils.getDB(this.mongo, this.databaseName, this.username, this.password == null ? null : this.password.toCharArray());
    }

    public DB getDb(String dbName) throws DataAccessException {
        Assert.notNull((Object)this.mongo, (String)"Mongo must not be null");
        Assert.hasText((String)dbName, (String)"Database name must not be empty");
        return MongoDbUtils.getDB(this.mongo, dbName, this.username, this.password == null ? null : this.password.toCharArray());
    }
}

