/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.document.mongodb.config;

import com.mongodb.Mongo;
import java.util.HashSet;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.annotation.Persistent;
import org.springframework.data.authentication.UserCredentials;
import org.springframework.data.document.mongodb.MongoDbFactory;
import org.springframework.data.document.mongodb.MongoTemplate;
import org.springframework.data.document.mongodb.SimpleMongoDbFactory;
import org.springframework.data.document.mongodb.convert.MappingMongoConverter;
import org.springframework.data.document.mongodb.mapping.Document;
import org.springframework.data.document.mongodb.mapping.MongoMappingContext;
import org.springframework.data.document.mongodb.mapping.MongoPersistentEntity;
import org.springframework.data.document.mongodb.mapping.MongoPersistentProperty;
import org.springframework.data.mapping.context.MappingContextAwareBeanPostProcessor;
import org.springframework.data.mapping.model.MappingContext;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@Configuration
public abstract class AbstractMongoConfiguration {
    public abstract String getDatabaseName();

    @Bean
    public abstract Mongo mongo() throws Exception;

    @Bean
    public MongoTemplate mongoTemplate() throws Exception {
        return new MongoTemplate(this.mongoDbFactory(), this.mappingMongoConverter());
    }

    @Bean
    public MongoDbFactory mongoDbFactory() throws Exception {
        if (this.getUserCredentials() == null) {
            return new SimpleMongoDbFactory(this.mongo(), this.getDatabaseName());
        }
        return new SimpleMongoDbFactory(this.mongo(), this.getDatabaseName(), this.getUserCredentials());
    }

    public String getMappingBasePackage() {
        return "";
    }

    public UserCredentials getUserCredentials() {
        return null;
    }

    @Bean
    public MongoMappingContext mongoMappingContext() throws ClassNotFoundException, LinkageError {
        MongoMappingContext mappingContext = new MongoMappingContext();
        String basePackage = this.getMappingBasePackage();
        if (StringUtils.hasText((String)basePackage)) {
            ClassPathScanningCandidateComponentProvider componentProvider = new ClassPathScanningCandidateComponentProvider(false);
            componentProvider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Document.class));
            componentProvider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Persistent.class));
            HashSet<Class> initialEntitySet = new HashSet<Class>();
            for (BeanDefinition candidate : componentProvider.findCandidateComponents(basePackage)) {
                initialEntitySet.add(ClassUtils.forName((String)candidate.getBeanClassName(), (ClassLoader)((Object)((Object)mappingContext)).getClass().getClassLoader()));
            }
            mappingContext.setInitialEntitySet(initialEntitySet);
        }
        return mappingContext;
    }

    @Bean
    public MappingMongoConverter mappingMongoConverter() throws Exception {
        MappingMongoConverter converter = new MappingMongoConverter(this.mongoDbFactory(), (MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty>)this.mongoMappingContext());
        this.afterMappingMongoConverterCreation(converter);
        return converter;
    }

    protected void afterMappingMongoConverterCreation(MappingMongoConverter converter) {
    }

    @Bean
    public MappingContextAwareBeanPostProcessor mappingContextAwareBeanPostProcessor() {
        MappingContextAwareBeanPostProcessor bpp = new MappingContextAwareBeanPostProcessor();
        bpp.setMappingContextBeanName("mongoMappingContext");
        return bpp;
    }
}

