/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.document.mongodb.config;

import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.authentication.UserCredentials;
import org.springframework.data.document.mongodb.MongoFactoryBean;
import org.springframework.data.document.mongodb.SimpleMongoDbFactory;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class MongoDbFactoryParser
extends AbstractBeanDefinitionParser {
    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        String id = element.getAttribute("id");
        if (!StringUtils.hasText((String)id)) {
            id = "mongoDbFactory";
        }
        return id;
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        String mongoRef;
        String dbname;
        String port;
        BeanDefinitionBuilder dbFactoryBuilder = BeanDefinitionBuilder.genericBeanDefinition(SimpleMongoDbFactory.class);
        BeanDefinitionBuilder userCredentialsBuilder = BeanDefinitionBuilder.genericBeanDefinition(UserCredentials.class);
        String username = element.getAttribute("username");
        if (StringUtils.hasText((String)username)) {
            userCredentialsBuilder.addConstructorArgValue((Object)username);
        } else {
            userCredentialsBuilder.addConstructorArgValue(null);
        }
        String password = element.getAttribute("password");
        if (StringUtils.hasText((String)password)) {
            userCredentialsBuilder.addConstructorArgValue((Object)password);
        } else {
            userCredentialsBuilder.addConstructorArgValue(null);
        }
        String host = element.getAttribute("host");
        if (!StringUtils.hasText((String)host)) {
            host = "localhost";
        }
        if (!StringUtils.hasText((String)(port = element.getAttribute("port")))) {
            port = "27017";
        }
        if (!StringUtils.hasText((String)(dbname = element.getAttribute("dbname")))) {
            dbname = "db";
        }
        if (!StringUtils.hasText((String)(mongoRef = element.getAttribute("mongo-ref")))) {
            BeanDefinitionBuilder mongoBuilder = BeanDefinitionBuilder.genericBeanDefinition(MongoFactoryBean.class);
            mongoBuilder.addPropertyValue("host", (Object)host);
            mongoBuilder.addPropertyValue("port", (Object)port);
            mongoRef = BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)mongoBuilder.getBeanDefinition(), (BeanDefinitionRegistry)parserContext.getRegistry());
        }
        dbFactoryBuilder.addConstructorArgValue((Object)new RuntimeBeanReference(mongoRef));
        dbFactoryBuilder.addConstructorArgValue((Object)dbname);
        dbFactoryBuilder.addConstructorArgValue((Object)userCredentialsBuilder.getBeanDefinition());
        return dbFactoryBuilder.getRawBeanDefinition();
    }
}

