/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.document.mongodb.convert;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.ConversionServiceFactory;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.document.mongodb.convert.MongoConverter;
import org.springframework.data.document.mongodb.convert.ObjectIdConverters;
import org.springframework.data.mapping.MappingBeanHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMongoConverter
implements MongoConverter,
InitializingBean {
    private static final List<Class<?>> MONGO_TYPES = Arrays.asList(Number.class, Date.class, String.class, DBObject.class);
    protected final GenericConversionService conversionService;
    private final Set<GenericConverter.ConvertiblePair> customTypeMapping = new HashSet<GenericConverter.ConvertiblePair>();

    public AbstractMongoConverter(GenericConversionService conversionService) {
        this.conversionService = conversionService == null ? ConversionServiceFactory.createDefaultConversionService() : conversionService;
        this.conversionService.removeConvertible(Object.class, String.class);
        this.registerConverter((Object)CustomToStringConverter.INSTANCE);
    }

    public void setCustomConverters(Set<?> converters) {
        if (null != converters) {
            for (Object c : converters) {
                this.registerConverter(c);
            }
        }
    }

    private void initializeConverters() {
        if (!this.conversionService.canConvert(ObjectId.class, String.class)) {
            this.conversionService.addConverter((Converter)ObjectIdConverters.ObjectIdToStringConverter.INSTANCE);
        }
        if (!this.conversionService.canConvert(String.class, ObjectId.class)) {
            this.conversionService.addConverter((Converter)ObjectIdConverters.StringToObjectIdConverter.INSTANCE);
        }
        if (!this.conversionService.canConvert(ObjectId.class, BigInteger.class)) {
            this.conversionService.addConverter((Converter)ObjectIdConverters.ObjectIdToBigIntegerConverter.INSTANCE);
        }
        if (!this.conversionService.canConvert(BigInteger.class, ObjectId.class)) {
            this.conversionService.addConverter((Converter)ObjectIdConverters.BigIntegerToObjectIdConverter.INSTANCE);
        }
    }

    private void registerConverter(Object converter) {
        if (converter instanceof GenericConverter) {
            this.customTypeMapping.addAll(((GenericConverter)converter).getConvertibleTypes());
        } else {
            Class[] arguments = GenericTypeResolver.resolveTypeArguments(converter.getClass(), Converter.class);
            if (MONGO_TYPES.contains(arguments[1]) || MONGO_TYPES.contains(arguments[0])) {
                this.customTypeMapping.add(new GenericConverter.ConvertiblePair(arguments[0], arguments[1]));
            }
        }
        boolean added = false;
        if (converter instanceof Converter) {
            this.conversionService.addConverter((Converter)converter);
            added = true;
        }
        if (converter instanceof ConverterFactory) {
            this.conversionService.addConverterFactory((ConverterFactory)converter);
            added = true;
        }
        if (converter instanceof GenericConverter) {
            this.conversionService.addConverter((GenericConverter)converter);
            added = true;
        }
        if (!added) {
            throw new IllegalArgumentException("Given set contains element that is neither Converter nor ConverterFactory!");
        }
    }

    protected Class<?> getCustomTarget(Class<?> source, Class<?> expectedTargetType) {
        for (GenericConverter.ConvertiblePair typePair : this.customTypeMapping) {
            Class targetType;
            if (!typePair.getSourceType().isAssignableFrom(source) || !(targetType = typePair.getTargetType()).equals(expectedTargetType) && expectedTargetType != null) continue;
            return targetType;
        }
        return null;
    }

    @Override
    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public void afterPropertiesSet() {
        this.initializeConverters();
    }

    @Override
    public Object maybeConvertObject(Object obj) {
        if (obj instanceof Enum) {
            return ((Enum)obj).name();
        }
        if (null != obj && MappingBeanHelper.isSimpleType(obj.getClass())) {
            return obj;
        }
        if (obj instanceof BasicDBList) {
            return this.maybeConvertList((BasicDBList)obj);
        }
        if (obj instanceof DBObject) {
            BasicDBObject newValueDbo = new BasicDBObject();
            for (String vk : ((DBObject)obj).keySet()) {
                Object o = ((DBObject)obj).get(vk);
                newValueDbo.put(vk, this.maybeConvertObject(o));
            }
            return newValueDbo;
        }
        if (obj instanceof Map) {
            HashMap m = new HashMap();
            for (Map.Entry entry : ((Map)obj).entrySet()) {
                m.put(entry.getKey(), this.maybeConvertObject(entry.getValue()));
            }
            return m;
        }
        if (obj instanceof List) {
            List l = (List)obj;
            ArrayList<Object> newList = new ArrayList<Object>();
            for (Object o : l) {
                newList.add(this.maybeConvertObject(o));
            }
            return newList;
        }
        if (obj.getClass().isArray()) {
            return this.maybeConvertArray((Object[])obj);
        }
        BasicDBObject newDbo = new BasicDBObject();
        this.write(obj, (DBObject)newDbo);
        return newDbo;
    }

    @Override
    public Object[] maybeConvertArray(Object[] src) {
        Object[] newArr = new Object[src.length];
        for (int i = 0; i < src.length; ++i) {
            newArr[i] = this.maybeConvertObject(src[i]);
        }
        return newArr;
    }

    @Override
    public BasicDBList maybeConvertList(BasicDBList dbl) {
        BasicDBList newDbl = new BasicDBList();
        for (Object o : dbl) {
            newDbl.add(this.maybeConvertObject(o));
        }
        return newDbl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CustomToStringConverter implements GenericConverter
    {
        INSTANCE;


        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            GenericConverter.ConvertiblePair localeToString = new GenericConverter.ConvertiblePair(Locale.class, String.class);
            GenericConverter.ConvertiblePair booleanToString = new GenericConverter.ConvertiblePair(Character.class, String.class);
            return new HashSet<GenericConverter.ConvertiblePair>(Arrays.asList(localeToString, booleanToString));
        }

        public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            return source.toString();
        }
    }
}

