/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.document.mongodb.convert;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBObject;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.BSONObject;
import org.bson.types.ObjectId;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConversionException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.ConversionServiceFactory;
import org.springframework.data.document.mongodb.MongoDbFactory;
import org.springframework.data.document.mongodb.convert.AbstractMongoConverter;
import org.springframework.data.document.mongodb.mapping.DBRef;
import org.springframework.data.document.mongodb.mapping.MongoPersistentEntity;
import org.springframework.data.document.mongodb.mapping.MongoPersistentProperty;
import org.springframework.data.mapping.AssociationHandler;
import org.springframework.data.mapping.BeanWrapper;
import org.springframework.data.mapping.MappingBeanHelper;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.model.Association;
import org.springframework.data.mapping.model.MappingContext;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.mapping.model.PersistentProperty;
import org.springframework.data.mapping.model.PreferredConstructor;
import org.springframework.data.mapping.model.SpELAwareParameterValueProvider;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingMongoConverter
extends AbstractMongoConverter
implements ApplicationContextAware {
    public static final String CUSTOM_TYPE_KEY = "_class";
    private static final List<Class<?>> VALID_ID_TYPES = Arrays.asList(ObjectId.class, String.class, BigInteger.class, byte[].class);
    protected static final Log log = LogFactory.getLog(MappingMongoConverter.class);
    protected final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;
    protected final SpelExpressionParser spelExpressionParser = new SpelExpressionParser();
    protected ApplicationContext applicationContext;
    protected boolean useFieldAccessOnly = true;
    protected MongoDbFactory mongoDbFactory;

    public MappingMongoConverter(MongoDbFactory mongoDbFactory, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext) {
        super(ConversionServiceFactory.createDefaultConversionService());
        Assert.notNull(mappingContext);
        Assert.notNull((Object)mongoDbFactory);
        this.mongoDbFactory = mongoDbFactory;
        this.mappingContext = mappingContext;
    }

    @Override
    public MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> getMappingContext() {
        return this.mappingContext;
    }

    public void setMongoDbFactory(MongoDbFactory mongoDbFactory) {
        this.mongoDbFactory = mongoDbFactory;
    }

    public boolean isUseFieldAccessOnly() {
        return this.useFieldAccessOnly;
    }

    public void setUseFieldAccessOnly(boolean useFieldAccessOnly) {
        this.useFieldAccessOnly = useFieldAccessOnly;
    }

    @Override
    public <T> T convertObjectId(ObjectId id, Class<T> targetType) {
        return (T)this.conversionService.convert((Object)id, targetType);
    }

    @Override
    public ObjectId convertObjectId(Object id) {
        return (ObjectId)this.conversionService.convert(id, ObjectId.class);
    }

    @Override
    public <S> S read(Class<S> clazz, DBObject dbo) {
        return this.read(ClassTypeInformation.from(clazz), dbo);
    }

    @Override
    protected <S> S read(TypeInformation<S> type, DBObject dbo) {
        if (null == dbo) {
            return null;
        }
        TypeInformation<S> typeToUse = this.getMoreConcreteTargetType(dbo, type);
        Class rawType = typeToUse.getType();
        Class<?> customTarget = this.getCustomTarget(rawType, DBObject.class);
        if (customTarget != null) {
            return (S)this.conversionService.convert((Object)dbo, rawType);
        }
        if (typeToUse.isCollectionLike() && dbo instanceof BasicDBList) {
            ArrayList<Object> l = new ArrayList<Object>();
            BasicDBList dbList = (BasicDBList)dbo;
            for (Object o : dbList) {
                if (o instanceof DBObject) {
                    S newObj = this.read(typeToUse.getComponentType(), (DBObject)o);
                    Class rawComponentType = typeToUse.getComponentType().getType();
                    if (newObj.getClass().isAssignableFrom(rawComponentType)) {
                        l.add(newObj);
                        continue;
                    }
                    l.add(this.conversionService.convert(newObj, rawComponentType));
                    continue;
                }
                l.add(o);
            }
            return (S)this.conversionService.convert(l, rawType);
        }
        MongoPersistentEntity persistentEntity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(typeToUse);
        if (persistentEntity == null) {
            throw new MappingException("No mapping metadata found for " + rawType.getName());
        }
        return this.read(persistentEntity, dbo);
    }

    @Override
    private <S> S read(MongoPersistentEntity<S> entity, final DBObject dbo) {
        final StandardEvaluationContext spelCtx = new StandardEvaluationContext();
        if (null != this.applicationContext) {
            spelCtx.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)this.applicationContext));
        }
        if (!(dbo instanceof BasicDBList)) {
            String[] keySet;
            for (String key : keySet = dbo.keySet().toArray(new String[0])) {
                spelCtx.setVariable(key, dbo.get(key));
            }
        }
        final ArrayList ctorParamNames = new ArrayList();
        final MongoPersistentProperty idProperty = (MongoPersistentProperty)entity.getIdProperty();
        SpELAwareParameterValueProvider provider = new SpELAwareParameterValueProvider(this.spelExpressionParser, (EvaluationContext)spelCtx){

            public <T> T getParameterValue(PreferredConstructor.Parameter<T> parameter) {
                if (parameter.getKey() != null) {
                    return (T)super.getParameterValue(parameter);
                }
                String name = parameter.getName();
                TypeInformation type = parameter.getType();
                Class rawType = parameter.getRawType();
                String key = idProperty == null ? name : (idProperty.getName().equals(name) ? idProperty.getFieldName() : name);
                Object obj = dbo.get(key);
                ctorParamNames.add(name);
                if (obj instanceof com.mongodb.DBRef) {
                    return (T)MappingMongoConverter.this.read(type, ((com.mongodb.DBRef)obj).fetch());
                }
                if (obj instanceof BasicDBList) {
                    BasicDBList objAsDbList = (BasicDBList)obj;
                    List<?> l = MappingMongoConverter.this.unwrapList(objAsDbList, type);
                    return (T)MappingMongoConverter.this.conversionService.convert(l, rawType);
                }
                if (obj instanceof DBObject) {
                    return (T)MappingMongoConverter.this.read(type, (DBObject)obj);
                }
                if (null != obj && obj.getClass().isAssignableFrom(rawType)) {
                    return (T)obj;
                }
                if (null != obj) {
                    return (T)MappingMongoConverter.this.conversionService.convert(obj, rawType);
                }
                return null;
            }
        };
        final BeanWrapper wrapper = BeanWrapper.create(entity, (ParameterValueProvider)provider, (ConversionService)this.conversionService);
        entity.doWithProperties((PropertyHandler)new PropertyHandler<MongoPersistentProperty>(){

            public void doWithPersistentProperty(MongoPersistentProperty prop) {
                boolean isConstructorProperty = ctorParamNames.contains(prop.getName());
                boolean hasValueForProperty = dbo.containsField(prop.getFieldName());
                if (!hasValueForProperty || isConstructorProperty) {
                    return;
                }
                Object obj = MappingMongoConverter.this.getValueInternal(prop, dbo, spelCtx, prop.getSpelExpression());
                try {
                    wrapper.setProperty((PersistentProperty)prop, obj, MappingMongoConverter.this.useFieldAccessOnly);
                }
                catch (IllegalAccessException e) {
                    throw new MappingException(e.getMessage(), (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    throw new MappingException(e.getMessage(), (Throwable)e);
                }
            }
        });
        entity.doWithAssociations((AssociationHandler)new AssociationHandler<MongoPersistentProperty>(){

            public void doWithAssociation(Association<MongoPersistentProperty> association) {
                MongoPersistentProperty inverseProp = (MongoPersistentProperty)association.getInverse();
                Object obj = MappingMongoConverter.this.getValueInternal(inverseProp, dbo, spelCtx, inverseProp.getSpelExpression());
                try {
                    wrapper.setProperty((PersistentProperty)inverseProp, obj);
                }
                catch (IllegalAccessException e) {
                    throw new MappingException(e.getMessage(), (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    throw new MappingException(e.getMessage(), (Throwable)e);
                }
            }
        });
        return (S)wrapper.getBean();
    }

    @Override
    public void write(Object obj, DBObject dbo) {
        boolean handledByCustomConverter;
        if (null == obj) {
            return;
        }
        boolean bl = handledByCustomConverter = this.getCustomTarget(obj.getClass(), DBObject.class) != null;
        if (!handledByCustomConverter) {
            dbo.put(CUSTOM_TYPE_KEY, (Object)obj.getClass().getName());
        }
        this.writeInternal(obj, dbo);
    }

    protected void writeInternal(Object obj, DBObject dbo) {
        if (null == obj) {
            return;
        }
        Class<?> customTarget = this.getCustomTarget(obj.getClass(), DBObject.class);
        if (customTarget != null) {
            DBObject result = (DBObject)this.conversionService.convert(obj, DBObject.class);
            dbo.putAll((BSONObject)result);
            return;
        }
        if (Map.class.isAssignableFrom(obj.getClass())) {
            this.writeMapInternal((Map)obj, dbo, null);
            return;
        }
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(obj.getClass());
        this.writeInternal(obj, dbo, entity);
    }

    protected void writeInternal(Object obj, final DBObject dbo, MongoPersistentEntity<?> entity) {
        if (obj == null) {
            return;
        }
        if (null == entity) {
            throw new MappingException("No mapping metadata found for entity of type " + obj.getClass().getName());
        }
        final BeanWrapper wrapper = BeanWrapper.create((Object)obj, (ConversionService)this.conversionService);
        final MongoPersistentProperty idProperty = (MongoPersistentProperty)entity.getIdProperty();
        if (!dbo.containsField("_id") && null != idProperty) {
            Class[] targetClasses;
            Object idObj = null;
            for (Class targetClasse : targetClasses = new Class[]{ObjectId.class, Object.class}) {
                try {
                    idObj = wrapper.getProperty((PersistentProperty)idProperty, targetClasse, this.useFieldAccessOnly);
                    if (null == idObj) continue;
                    break;
                }
                catch (ConversionException ignored) {
                }
                catch (IllegalAccessException e) {
                    throw new MappingException(e.getMessage(), (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    throw new MappingException(e.getMessage(), (Throwable)e);
                }
            }
            if (null != idObj) {
                dbo.put("_id", idObj);
            } else if (!VALID_ID_TYPES.contains(idProperty.getType())) {
                throw new MappingException("Invalid data type " + idProperty.getType().getName() + " for Id property. Should be one of " + VALID_ID_TYPES);
            }
        }
        entity.doWithProperties((PropertyHandler)new PropertyHandler<MongoPersistentProperty>(){

            public void doWithPersistentProperty(MongoPersistentProperty prop) {
                Object propertyObj;
                if (prop.equals(idProperty)) {
                    return;
                }
                try {
                    propertyObj = wrapper.getProperty((PersistentProperty)prop, prop.getType(), MappingMongoConverter.this.useFieldAccessOnly);
                }
                catch (IllegalAccessException e) {
                    throw new MappingException(e.getMessage(), (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    throw new MappingException(e.getMessage(), (Throwable)e);
                }
                if (null != propertyObj) {
                    if (!MappingBeanHelper.isSimpleType(propertyObj.getClass())) {
                        MappingMongoConverter.this.writePropertyInternal(prop, propertyObj, dbo);
                    } else {
                        MappingMongoConverter.this.writeSimpleInternal(prop.getFieldName(), propertyObj, dbo);
                    }
                }
            }
        });
        entity.doWithAssociations((AssociationHandler)new AssociationHandler<MongoPersistentProperty>(){

            public void doWithAssociation(Association<MongoPersistentProperty> association) {
                Object propertyObj;
                MongoPersistentProperty inverseProp = (MongoPersistentProperty)association.getInverse();
                Class type = inverseProp.getType();
                try {
                    propertyObj = wrapper.getProperty((PersistentProperty)inverseProp, type, MappingMongoConverter.this.useFieldAccessOnly);
                }
                catch (IllegalAccessException e) {
                    throw new MappingException(e.getMessage(), (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    throw new MappingException(e.getMessage(), (Throwable)e);
                }
                if (null != propertyObj) {
                    MappingMongoConverter.this.writePropertyInternal(inverseProp, propertyObj, dbo);
                }
            }
        });
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    protected void writePropertyInternal(MongoPersistentProperty prop, Object obj, DBObject dbo) {
        com.mongodb.DBRef dbRefObj;
        if (obj == null) {
            return;
        }
        String name = prop.getFieldName();
        if (prop.isCollection()) {
            DBObject collectionInternal = this.writeCollectionInternal(prop, obj);
            dbo.put(name, (Object)collectionInternal);
            return;
        }
        if (prop.isMap()) {
            BasicDBObject mapDbObj = new BasicDBObject();
            this.writeMapInternal((Map)obj, (DBObject)mapDbObj, prop.getTypeInformation());
            dbo.put(name, (Object)mapDbObj);
            return;
        }
        if (prop.isDbReference() && null != (dbRefObj = this.createDBRef(obj, prop.getDBRef()))) {
            dbo.put(name, (Object)dbRefObj);
            return;
        }
        Class<?> basicTargetType = this.getCustomTarget(obj.getClass(), null);
        if (basicTargetType != null) {
            dbo.put(name, this.conversionService.convert(obj, basicTargetType));
            return;
        }
        BasicDBObject propDbObj = new BasicDBObject();
        this.addCustomTypeKeyIfNecessary(prop.getTypeInformation(), obj, (DBObject)propDbObj);
        this.writeInternal(obj, (DBObject)propDbObj, (MongoPersistentEntity)this.mappingContext.getPersistentEntity(prop.getTypeInformation()));
        dbo.put(name, (Object)propDbObj);
    }

    protected DBObject writeCollectionInternal(MongoPersistentProperty property, Object obj) {
        BasicDBList dbList = new BasicDBList();
        Class type = property.getType();
        Collection coll = type.isArray() ? CollectionUtils.arrayToList((Object)obj) : (Collection)obj;
        TypeInformation componentType = property.getTypeInformation().getComponentType();
        for (Object element : coll) {
            if (element == null) continue;
            TypeInformation valueType = ClassTypeInformation.from(element.getClass());
            if (property.isDbReference()) {
                com.mongodb.DBRef dbRef = this.createDBRef(element, property.getDBRef());
                dbList.add((Object)dbRef);
                continue;
            }
            if (type.isArray() && MappingBeanHelper.isSimpleType((Class)property.getComponentType())) {
                dbList.add(element);
                continue;
            }
            if (element instanceof List) {
                List propObjColl = (List)element;
                while (valueType.isCollectionLike()) {
                    valueType = valueType.getComponentType();
                }
                if (MappingBeanHelper.isSimpleType((Class)valueType.getType())) {
                    dbList.add((Object)propObjColl);
                    continue;
                }
                BasicDBList propNestedDbList = new BasicDBList();
                for (Object propNestedObjItem : propObjColl) {
                    BasicDBObject propDbObj = new BasicDBObject();
                    this.writeInternal(propNestedObjItem, (DBObject)propDbObj);
                    propNestedDbList.add((Object)propDbObj);
                }
                dbList.add((Object)propNestedDbList);
                continue;
            }
            if (MappingBeanHelper.isSimpleType(element.getClass())) {
                dbList.add(element);
                continue;
            }
            BasicDBObject propDbObj = new BasicDBObject();
            this.writeInternal(element, (DBObject)propDbObj, (MongoPersistentEntity)this.mappingContext.getPersistentEntity(valueType));
            this.addCustomTypeKeyIfNecessary(componentType, element, (DBObject)propDbObj);
            dbList.add((Object)propDbObj);
        }
        return dbList;
    }

    protected void writeMapInternal(Map<Object, Object> obj, DBObject dbo, TypeInformation<?> propertyType) {
        for (Map.Entry<Object, Object> entry : obj.entrySet()) {
            Object key = entry.getKey();
            Object val = entry.getValue();
            if (MappingBeanHelper.isSimpleType(key.getClass())) {
                String simpleKey = key.toString();
                if (MappingBeanHelper.isSimpleType(val.getClass())) {
                    this.writeSimpleInternal(simpleKey, val, dbo);
                    continue;
                }
                BasicDBObject newDbo = new BasicDBObject();
                this.writeInternal(val, (DBObject)newDbo);
                this.addCustomTypeKeyIfNecessary(propertyType, val, (DBObject)newDbo);
                dbo.put(simpleKey, (Object)newDbo);
                continue;
            }
            throw new MappingException("Cannot use a complex object as a key value.");
        }
    }

    public void addCustomTypeKeyIfNecessary(TypeInformation<?> type, Object value, DBObject dbObject) {
        boolean notTheSameClass;
        if (type == null) {
            return;
        }
        Class reference = this.getValueType(type).getType();
        boolean bl = notTheSameClass = !value.getClass().equals(reference);
        if (notTheSameClass) {
            dbObject.put(CUSTOM_TYPE_KEY, (Object)value.getClass().getName());
        }
    }

    public TypeInformation<?> getValueType(TypeInformation<?> type) {
        if (type.isMap()) {
            return type.getMapValueType();
        }
        if (type.isCollectionLike()) {
            return type.getComponentType();
        }
        return type;
    }

    private void writeSimpleInternal(String key, Object value, DBObject dbObject) {
        Class<?> customTarget = this.getCustomTarget(value.getClass(), null);
        Object valueToSet = null;
        valueToSet = customTarget != null ? this.conversionService.convert(value, customTarget) : (value.getClass().isEnum() ? ((Enum)value).name() : value);
        dbObject.put(key, valueToSet);
    }

    protected com.mongodb.DBRef createDBRef(Object target, DBRef dbref) {
        String dbname;
        MongoPersistentEntity targetEntity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(target.getClass());
        if (null == targetEntity || null == targetEntity.getIdProperty()) {
            return null;
        }
        MongoPersistentProperty idProperty = (MongoPersistentProperty)targetEntity.getIdProperty();
        ObjectId id = null;
        BeanWrapper wrapper = BeanWrapper.create((Object)target, (ConversionService)this.conversionService);
        try {
            id = (ObjectId)wrapper.getProperty((PersistentProperty)idProperty, ObjectId.class, this.useFieldAccessOnly);
            if (null == id) {
                throw new MappingException("Cannot create a reference to an object with a NULL id.");
            }
        }
        catch (IllegalAccessException e) {
            throw new MappingException(e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new MappingException(e.getMessage(), (Throwable)e);
        }
        String collection = dbref.collection();
        if ("".equals(collection)) {
            collection = targetEntity.getCollection();
        }
        DB db = StringUtils.hasText((String)(dbname = dbref.db())) ? this.mongoDbFactory.getDb(dbname) : this.mongoDbFactory.getDb();
        return new com.mongodb.DBRef(db, collection, (Object)id);
    }

    protected Object getValueInternal(MongoPersistentProperty prop, DBObject dbo, StandardEvaluationContext ctx, String spelExpr) {
        Object o;
        if (null != spelExpr) {
            Expression x = this.spelExpressionParser.parseExpression(spelExpr);
            o = x.getValue((EvaluationContext)ctx);
        } else {
            Object dbObj = dbo.get(prop.getFieldName());
            if (dbObj == null) {
                return null;
            }
            Class propertyType = prop.getType();
            Class<?> customTarget = this.getCustomTarget(dbObj.getClass(), propertyType);
            if (customTarget != null) {
                return this.conversionService.convert(dbObj, propertyType);
            }
            if (dbObj instanceof com.mongodb.DBRef) {
                dbObj = ((com.mongodb.DBRef)dbObj).fetch();
            }
            if (dbObj instanceof DBObject) {
                if (prop.isMap()) {
                    return this.readMap(prop.getTypeInformation(), (DBObject)dbObj);
                }
                if (prop.isArray() && dbObj instanceof BasicDBObject && ((DBObject)dbObj).keySet().size() == 0) {
                    return Array.newInstance(prop.getComponentType(), 0);
                }
                if (prop.isCollection() && dbObj instanceof BasicDBList) {
                    BasicDBList dbObjList = (BasicDBList)dbObj;
                    LinkedList<Object> items = new LinkedList<Object>();
                    for (int i = 0; i < dbObjList.size(); ++i) {
                        Object dbObjItem = dbObjList.get(i);
                        if (dbObjItem instanceof com.mongodb.DBRef) {
                            items.add(this.read(prop.getComponentType(), ((com.mongodb.DBRef)dbObjItem).fetch()));
                            continue;
                        }
                        if (dbObjItem instanceof DBObject) {
                            items.add(this.read(prop.getComponentType(), (DBObject)dbObjItem));
                            continue;
                        }
                        items.add(dbObjItem);
                    }
                    LinkedList itemsToReturn = new LinkedList();
                    for (Object e : items) {
                        itemsToReturn.add(e);
                    }
                    return itemsToReturn;
                }
                Class<?> toType = this.findTypeToBeUsed((DBObject)dbObj);
                if (toType != null) {
                    dbo.removeField(CUSTOM_TYPE_KEY);
                    o = this.read(toType, (DBObject)dbObj);
                } else {
                    o = this.read((MongoPersistentEntity)this.mappingContext.getPersistentEntity(prop.getTypeInformation()), (DBObject)dbObj);
                }
            } else {
                o = dbObj;
            }
        }
        return o;
    }

    private Map<Object, Object> readMap(TypeInformation<?> type, DBObject dbObject) {
        Assert.notNull(type);
        Assert.isTrue((boolean)type.isMap());
        Assert.notNull((Object)dbObject);
        Class<?> customMapType = this.findTypeToBeUsed(dbObject);
        Class mapType = customMapType == null ? Map.class : customMapType;
        Map map = CollectionFactory.createMap(mapType, (int)dbObject.keySet().size());
        Map sourceMap = dbObject.toMap();
        for (Map.Entry entry : sourceMap.entrySet()) {
            if (((String)entry.getKey()).equals(CUSTOM_TYPE_KEY)) continue;
            Class keyType = type.getComponentType().getType();
            Object key = this.conversionService.convert(entry.getKey(), keyType);
            if (null != entry.getValue() && entry.getValue() instanceof DBObject) {
                DBObject valueSource = (DBObject)entry.getValue();
                TypeInformation valueType = type.getMapValueType();
                Map<Object, Object> value = valueType.isMap() ? this.readMap(valueType, valueSource) : this.read(valueType, valueSource);
                map.put(key, value);
                continue;
            }
            map.put(key, entry.getValue());
        }
        return map;
    }

    protected Class<?> findTypeToBeUsed(DBObject dbObject) {
        Object classToBeUsed = dbObject.get(CUSTOM_TYPE_KEY);
        if (classToBeUsed == null) {
            return null;
        }
        try {
            return Class.forName(classToBeUsed.toString());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private <S> TypeInformation<? extends S> getMoreConcreteTargetType(DBObject dbObject, TypeInformation<S> basicType) {
        Class<?> documentsTargetType = this.findTypeToBeUsed(dbObject);
        Class rawType = basicType.getType();
        boolean isMoreConcreteCustomType = documentsTargetType != null && rawType.isAssignableFrom(documentsTargetType);
        return isMoreConcreteCustomType ? ClassTypeInformation.from(documentsTargetType) : basicType;
    }

    protected <T> List<?> unwrapList(BasicDBList dbList, TypeInformation<T> targetType) {
        LinkedList<Object> rootList = new LinkedList<Object>();
        for (int i = 0; i < dbList.size(); ++i) {
            Object obj = dbList.get(i);
            if (obj instanceof BasicDBList) {
                rootList.add(this.unwrapList((BasicDBList)obj, targetType.getComponentType()));
                continue;
            }
            if (obj instanceof DBObject) {
                rootList.add(this.read(targetType, (DBObject)obj));
                continue;
            }
            rootList.add(obj);
        }
        return rootList;
    }
}

