/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.document.mongodb.convert;

import java.math.BigInteger;
import org.bson.types.ObjectId;
import org.springframework.core.convert.converter.Converter;

abstract class ObjectIdConverters {
    private ObjectIdConverters() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BigIntegerToObjectIdConverter implements Converter<BigInteger, ObjectId>
    {
        INSTANCE;


        public ObjectId convert(BigInteger source) {
            return new ObjectId(source.toString(16));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ObjectIdToBigIntegerConverter implements Converter<ObjectId, BigInteger>
    {
        INSTANCE;


        public BigInteger convert(ObjectId source) {
            return new BigInteger(source.toString(), 16);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StringToObjectIdConverter implements Converter<String, ObjectId>
    {
        INSTANCE;


        public ObjectId convert(String source) {
            return new ObjectId(source);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ObjectIdToStringConverter implements Converter<ObjectId, String>
    {
        INSTANCE;


        public String convert(ObjectId id) {
            return id.toString();
        }
    }
}

