/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.document.mongodb.convert;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.types.CodeWScope;
import org.bson.types.ObjectId;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.ConversionServiceFactory;
import org.springframework.data.document.mongodb.MongoPropertyDescriptors;
import org.springframework.data.document.mongodb.convert.AbstractMongoConverter;
import org.springframework.data.document.mongodb.convert.MongoBeanWrapper;
import org.springframework.data.document.mongodb.mapping.MongoPersistentEntity;
import org.springframework.data.document.mongodb.mapping.MongoPersistentProperty;
import org.springframework.data.document.mongodb.mapping.SimpleMongoMappingContext;
import org.springframework.data.mapping.model.MappingContext;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class SimpleMongoConverter
extends AbstractMongoConverter
implements InitializingBean {
    private static final Log LOG = LogFactory.getLog(SimpleMongoConverter.class);
    private static final List<Class<?>> MONGO_TYPES = Arrays.asList(Number.class, Date.class, String.class, DBObject.class);
    private static final Set<String> SIMPLE_TYPES;
    private final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext = new SimpleMongoMappingContext();

    public SimpleMongoConverter() {
        super(ConversionServiceFactory.createDefaultConversionService());
    }

    @Override
    public MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> getMappingContext() {
        return this.mappingContext;
    }

    @Override
    public void write(Object obj, DBObject dbo) {
        MongoBeanWrapper beanWrapper = this.createWrapper(obj, false);
        for (MongoPropertyDescriptors.MongoPropertyDescriptor descriptor : beanWrapper.getDescriptors()) {
            if (descriptor.isMappable()) {
                Object value = beanWrapper.getValue(descriptor);
                if (value == null) continue;
                String keyToUse = descriptor.getKeyToMap();
                if (descriptor.isEnum()) {
                    this.writeValue(dbo, keyToUse, ((Enum)value).name());
                    continue;
                }
                if (descriptor.isIdProperty() && descriptor.isOfIdType()) {
                    if (value instanceof String && ObjectId.isValid((String)((String)value))) {
                        try {
                            this.writeValue(dbo, keyToUse, this.conversionService.convert(value, ObjectId.class));
                        }
                        catch (ConversionFailedException iae) {
                            LOG.warn((Object)("Unable to convert the String " + value + " to an ObjectId"));
                            this.writeValue(dbo, keyToUse, value);
                        }
                        continue;
                    }
                    this.writeValue(dbo, keyToUse, value);
                    continue;
                }
                this.writeValue(dbo, keyToUse, value);
                continue;
            }
            if ("class".equals(descriptor.getName())) continue;
            LOG.debug((Object)("Skipping property " + descriptor.getName() + " as it's not a mappable one."));
        }
    }

    private void writeValue(DBObject dbo, String keyToUse, Object value) {
        if (!SimpleMongoConverter.isSimpleType(value.getClass())) {
            this.writeCompoundValue(dbo, keyToUse, value);
        } else {
            dbo.put(keyToUse, value);
        }
    }

    private void writeCompoundValue(DBObject dbo, String keyToUse, Object value) {
        if (value instanceof Map) {
            this.writeMap(dbo, keyToUse, (Map)value);
            return;
        }
        if (value instanceof Collection) {
            this.writeArray(dbo, keyToUse, ((Collection)value).toArray());
            return;
        }
        if (value instanceof Object[]) {
            this.writeArray(dbo, keyToUse, (Object[])value);
            return;
        }
        Class<?> customTargetType = this.getCustomTargetType(value);
        if (customTargetType != null) {
            dbo.put(keyToUse, this.conversionService.convert(value, customTargetType));
            return;
        }
        BasicDBObject nestedDbo = new BasicDBObject();
        this.write(value, (DBObject)nestedDbo);
        dbo.put(keyToUse, (Object)nestedDbo);
    }

    private Class<?> getCustomTargetType(Object obj) {
        for (Class<?> mongoType : MONGO_TYPES) {
            if (!this.conversionService.canConvert(obj.getClass(), mongoType)) continue;
            return mongoType;
        }
        return null;
    }

    protected void writeMap(DBObject dbo, String mapKey, Map<String, Object> map) {
        Object dboToPopulate = null;
        dboToPopulate = mapKey != null ? new BasicDBObject() : dbo;
        if (map != null) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                Object entryValue = entry.getValue();
                String entryKey = entry.getKey();
                if (!SimpleMongoConverter.isSimpleType(entryValue.getClass())) {
                    this.writeCompoundValue((DBObject)dboToPopulate, entryKey, entryValue);
                    continue;
                }
                dboToPopulate.put(entryKey, entryValue);
            }
            dbo.put(mapKey, dboToPopulate);
        }
    }

    protected void writeArray(DBObject dbo, String keyToUse, Object[] array) {
        if (array != null) {
            Object[] dboValues = new Object[array.length];
            int i = 0;
            for (Object o : array) {
                if (!SimpleMongoConverter.isSimpleType(o.getClass())) {
                    BasicDBObject dboValue = new BasicDBObject();
                    this.write(o, (DBObject)dboValue);
                    dboValues[i] = dboValue;
                } else {
                    dboValues[i] = o;
                }
                ++i;
            }
            dbo.put(keyToUse, (Object)dboValues);
        }
    }

    @Override
    public <S> S read(Class<S> clazz, DBObject source) {
        if (source == null) {
            return null;
        }
        Assert.notNull(clazz, (String)"Mapped class was not specified");
        Object target = BeanUtils.instantiateClass(clazz);
        MongoBeanWrapper bw = new MongoBeanWrapper(target, (ConversionService)this.conversionService, true);
        for (MongoPropertyDescriptors.MongoPropertyDescriptor descriptor : bw.getDescriptors()) {
            String keyToUse = descriptor.getKeyToMap();
            if (!source.containsField(keyToUse)) continue;
            if (descriptor.isMappable()) {
                Object value = source.get(keyToUse);
                if (!SimpleMongoConverter.isSimpleType(value.getClass())) {
                    if (value instanceof Object[]) {
                        bw.setValue(descriptor, this.readCollection(descriptor, Arrays.asList((Object[])value)).toArray());
                        continue;
                    }
                    if (value instanceof BasicDBList) {
                        bw.setValue(descriptor, this.readCollection(descriptor, (Collection<?>)((BasicDBList)value)));
                        continue;
                    }
                    if (value instanceof DBObject) {
                        bw.setValue(descriptor, this.readCompoundValue(descriptor, (DBObject)value));
                        continue;
                    }
                    LOG.warn((Object)("Unable to map compound DBObject field " + keyToUse + " to property " + descriptor.getName() + ".  The field value should have been a 'DBObject.class' but was " + value.getClass().getName()));
                    continue;
                }
                bw.setValue(descriptor, value);
                continue;
            }
            LOG.warn((Object)("Unable to map DBObject field " + keyToUse + " to property " + descriptor.getName() + ".  Skipping."));
        }
        return (S)target;
    }

    private Collection<Object> readCollection(MongoPropertyDescriptors.MongoPropertyDescriptor descriptor, Collection<?> values) {
        Class<?> targetCollectionType = descriptor.getPropertyType();
        boolean targetIsArray = targetCollectionType.isArray();
        ArrayList<Object> result = targetIsArray ? new ArrayList(values.size()) : CollectionFactory.createCollection(targetCollectionType, (int)values.size());
        for (Object o : values) {
            if (o instanceof DBObject) {
                Class<?> type = targetIsArray ? targetCollectionType.getComponentType() : this.getGenericParameters(descriptor.getTypeToSet()).get(0);
                result.add(this.read(type, (DBObject)o));
                continue;
            }
            result.add(o);
        }
        return result;
    }

    private Object readCompoundValue(MongoPropertyDescriptors.MongoPropertyDescriptor pd, DBObject dbo) {
        Assert.isTrue((!pd.isCollection() ? 1 : 0) != 0, (String)"Collections not supported!");
        if (pd.isMap()) {
            return this.readMap(pd, dbo, this.getGenericParameters(pd.getTypeToSet()).get(1));
        }
        return this.read(pd.getPropertyType(), dbo);
    }

    protected Map<String, Object> createMap() {
        return new HashMap<String, Object>();
    }

    protected Map<?, ?> readMap(MongoPropertyDescriptors.MongoPropertyDescriptor pd, DBObject dbo, Class<?> targetType) {
        Map<String, Object> map = this.createMap();
        for (String key : dbo.keySet()) {
            Object value = dbo.get(key);
            if (!SimpleMongoConverter.isSimpleType(value.getClass())) {
                map.put(key, this.read(targetType, (DBObject)value));
                continue;
            }
            map.put(key, this.conversionService.convert(value, targetType));
        }
        return map;
    }

    protected static boolean isSimpleType(Class<?> propertyType) {
        if (propertyType == null) {
            return false;
        }
        if (propertyType.isArray()) {
            return SimpleMongoConverter.isSimpleType(propertyType.getComponentType());
        }
        return SIMPLE_TYPES.contains(propertyType.getName());
    }

    protected MongoBeanWrapper createWrapper(Object target, boolean fieldAccess) {
        return new MongoBeanWrapper(target, (ConversionService)this.conversionService, fieldAccess);
    }

    public List<Class<?>> getGenericParameters(Type genericParameterType) {
        ArrayList actualGenericParameterTypes = new ArrayList();
        if (genericParameterType instanceof ParameterizedType) {
            Type[] parameterArgTypes;
            ParameterizedType aType = (ParameterizedType)genericParameterType;
            for (Type parameterArgType : parameterArgTypes = aType.getActualTypeArguments()) {
                if (parameterArgType instanceof GenericArrayType) {
                    Class arrayType = (Class)((GenericArrayType)parameterArgType).getGenericComponentType();
                    actualGenericParameterTypes.add(Array.newInstance(arrayType, 0).getClass());
                    continue;
                }
                if (parameterArgType instanceof ParameterizedType) {
                    ParameterizedType paramTypeArgs = (ParameterizedType)parameterArgType;
                    actualGenericParameterTypes.add((Class)paramTypeArgs.getRawType());
                    continue;
                }
                if (parameterArgType instanceof TypeVariable) {
                    throw new RuntimeException("Can not map " + ((TypeVariable)parameterArgType).getName());
                }
                if (parameterArgType instanceof Class) {
                    actualGenericParameterTypes.add((Class)parameterArgType);
                    continue;
                }
                throw new RuntimeException("Can not map " + parameterArgType);
            }
        }
        return actualGenericParameterTypes;
    }

    @Override
    public <T> T convertObjectId(ObjectId id, Class<T> targetType) {
        return (T)this.conversionService.convert((Object)id, targetType);
    }

    @Override
    public ObjectId convertObjectId(Object id) {
        return (ObjectId)this.conversionService.convert(id, ObjectId.class);
    }

    static {
        HashSet<String> basics = new HashSet<String>();
        basics.add(Boolean.TYPE.getName());
        basics.add(Long.TYPE.getName());
        basics.add(Short.TYPE.getName());
        basics.add(Integer.TYPE.getName());
        basics.add(Byte.TYPE.getName());
        basics.add(Float.TYPE.getName());
        basics.add(Double.TYPE.getName());
        basics.add(Character.TYPE.getName());
        basics.add(Boolean.class.getName());
        basics.add(Long.class.getName());
        basics.add(Short.class.getName());
        basics.add(Integer.class.getName());
        basics.add(Byte.class.getName());
        basics.add(Float.class.getName());
        basics.add(Double.class.getName());
        basics.add(Character.class.getName());
        basics.add(String.class.getName());
        basics.add(Date.class.getName());
        basics.add(Locale.class.getName());
        basics.add(Class.class.getName());
        basics.add(DBRef.class.getName());
        basics.add(Pattern.class.getName());
        basics.add(CodeWScope.class.getName());
        basics.add(ObjectId.class.getName());
        basics.add(Enum.class.getName());
        SIMPLE_TYPES = Collections.unmodifiableSet(basics);
    }
}

