/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.document.mongodb.geo;

import org.springframework.data.document.mongodb.geo.Point;
import org.springframework.util.Assert;

public class Box {
    private final Point first;
    private final Point second;

    public Box(Point lowerLeft, Point upperRight) {
        Assert.notNull((Object)lowerLeft);
        Assert.notNull((Object)upperRight);
        this.first = lowerLeft;
        this.second = upperRight;
    }

    public Box(double[] lowerLeft, double[] upperRight) {
        Assert.isTrue((lowerLeft.length == 2 ? 1 : 0) != 0, (String)"Point array has to have 2 elements!");
        Assert.isTrue((upperRight.length == 2 ? 1 : 0) != 0, (String)"Point array has to have 2 elements!");
        this.first = new Point(lowerLeft[0], lowerLeft[1]);
        this.second = new Point(upperRight[0], upperRight[1]);
    }

    public Point getLowerLeft() {
        return this.first;
    }

    public Point getUpperRight() {
        return this.second;
    }

    public String toString() {
        return String.format("Box [%s, %s]", this.first, this.second);
    }

    public int hashCode() {
        int result = 31;
        result += 17 * this.first.hashCode();
        return result += 17 * this.second.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Box that = (Box)obj;
        return this.first.equals(that.first) && this.second.equals(that.second);
    }
}

