/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.document.mongodb.mapping;

import org.springframework.data.document.mongodb.MongoCollectionUtils;
import org.springframework.data.document.mongodb.mapping.Document;
import org.springframework.data.document.mongodb.mapping.MongoPersistentEntity;
import org.springframework.data.document.mongodb.mapping.MongoPersistentProperty;
import org.springframework.data.mapping.BasicPersistentEntity;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicMongoPersistentEntity<T>
extends BasicPersistentEntity<T, MongoPersistentProperty>
implements MongoPersistentEntity<T> {
    private final String collection;
    private final boolean isRootEntity;

    public BasicMongoPersistentEntity(TypeInformation<T> typeInformation) {
        super(typeInformation);
        Class rawType = typeInformation.getType();
        String fallback = MongoCollectionUtils.getPreferredCollectionName(rawType);
        if (rawType.isAnnotationPresent(Document.class)) {
            Document d = rawType.getAnnotation(Document.class);
            this.collection = StringUtils.hasText((String)d.collection()) ? d.collection() : fallback;
            this.isRootEntity = true;
        } else {
            this.collection = fallback;
            this.isRootEntity = false;
        }
    }

    @Override
    public String getCollection() {
        return this.collection;
    }

    public void verify() {
        if (this.isRootEntity && this.idProperty == null) {
            throw new MappingException(String.format("Root entity %s has to have an id property!", this.getType().getName()));
        }
    }
}

