/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.document.mongodb.mapping;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.types.ObjectId;
import org.springframework.data.document.mongodb.mapping.DBRef;
import org.springframework.data.document.mongodb.mapping.FieldName;
import org.springframework.data.document.mongodb.mapping.MongoPersistentEntity;
import org.springframework.data.document.mongodb.mapping.MongoPersistentProperty;
import org.springframework.data.mapping.AnnotationBasedPersistentProperty;
import org.springframework.data.mapping.model.Association;
import org.springframework.data.mapping.model.PersistentProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicMongoPersistentProperty
extends AnnotationBasedPersistentProperty<MongoPersistentProperty>
implements MongoPersistentProperty {
    private static final Log LOG = LogFactory.getLog(BasicMongoPersistentProperty.class);
    private static final Set<Class<?>> SUPPORTED_ID_TYPES = new HashSet();
    private static final Set<String> SUPPORTED_ID_PROPERTY_NAMES = new HashSet<String>();

    public BasicMongoPersistentProperty(Field field, PropertyDescriptor propertyDescriptor, MongoPersistentEntity<?> owner) {
        super(field, propertyDescriptor, owner);
        if (this.isIdProperty() && field.isAnnotationPresent(FieldName.class)) {
            LOG.warn((Object)String.format("Invalid usage of %s on id property. Field name will not be considered!", FieldName.class));
        }
    }

    public boolean isAssociation() {
        return this.field.isAnnotationPresent(DBRef.class) || super.isAssociation();
    }

    public boolean isIdProperty() {
        if (super.isIdProperty()) {
            return true;
        }
        return SUPPORTED_ID_PROPERTY_NAMES.contains(this.field.getName());
    }

    @Override
    public String getFieldName() {
        if (this.isIdProperty()) {
            return "_id";
        }
        FieldName annotation = this.getField().getAnnotation(FieldName.class);
        return annotation != null ? annotation.value() : this.getName();
    }

    protected Association<MongoPersistentProperty> createAssociation() {
        return new Association((PersistentProperty)this, null);
    }

    @Override
    public boolean isDbReference() {
        return this.getField().isAnnotationPresent(DBRef.class);
    }

    @Override
    public DBRef getDBRef() {
        return this.getField().getAnnotation(DBRef.class);
    }

    static {
        SUPPORTED_ID_TYPES.add(ObjectId.class);
        SUPPORTED_ID_TYPES.add(String.class);
        SUPPORTED_ID_TYPES.add(BigInteger.class);
        SUPPORTED_ID_PROPERTY_NAMES.add("id");
        SUPPORTED_ID_PROPERTY_NAMES.add("_id");
    }
}

