/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.document.mongodb.mapping.event;

import com.mongodb.DBObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.data.document.mongodb.mapping.event.AfterConvertEvent;
import org.springframework.data.document.mongodb.mapping.event.AfterLoadEvent;
import org.springframework.data.document.mongodb.mapping.event.AfterSaveEvent;
import org.springframework.data.document.mongodb.mapping.event.BeforeConvertEvent;
import org.springframework.data.document.mongodb.mapping.event.BeforeSaveEvent;
import org.springframework.data.document.mongodb.mapping.event.MongoMappingEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMappingEventListener<T extends ApplicationEvent, E>
implements ApplicationListener<T> {
    protected final Log log = LogFactory.getLog(this.getClass());

    public void onApplicationEvent(T appEvent) {
        if (appEvent instanceof MongoMappingEvent) {
            try {
                MongoMappingEvent event = (MongoMappingEvent)((Object)appEvent);
                if (event instanceof BeforeConvertEvent) {
                    this.onBeforeConvert(event.getSource());
                } else if (event instanceof BeforeSaveEvent) {
                    this.onBeforeSave(event.getSource(), event.getDBObject());
                } else if (event instanceof AfterSaveEvent) {
                    this.onAfterSave(event.getSource(), event.getDBObject());
                } else if (event instanceof AfterLoadEvent) {
                    this.onAfterLoad((DBObject)event.getSource());
                } else if (event instanceof AfterConvertEvent) {
                    this.onAfterConvert(event.getDBObject(), event.getSource());
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    public void onBeforeConvert(E source) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("onBeforeConvert(" + source + ")"));
        }
    }

    public void onBeforeSave(E source, DBObject dbo) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("onBeforeSave(" + source + ", " + dbo + ")"));
        }
    }

    public void onAfterSave(E source, DBObject dbo) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("onAfterSave(" + source + ", " + dbo + ")"));
        }
    }

    public void onAfterLoad(DBObject dbo) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("onAfterLoad(" + dbo + ")"));
        }
    }

    public void onAfterConvert(DBObject dbo, E source) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("onAfterConvert(" + dbo + "," + source + ")"));
        }
    }
}

