/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.document.mongodb.mapping.event;

import com.mongodb.DBObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.document.mongodb.mapping.event.AbstractMappingEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingEventListener<MongoMappingEvent>
extends AbstractMappingEventListener {
    private Log log = LogFactory.getLog(this.getClass());

    public void onBeforeConvert(Object source) {
        this.log.info((Object)("onBeforeConvert: " + source));
    }

    public void onBeforeSave(Object source, DBObject dbo) {
        try {
            this.log.info((Object)("onBeforeSave: " + source + ", " + dbo));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void onAfterSave(Object source, DBObject dbo) {
        this.log.info((Object)("onAfterSave: " + source + ", " + dbo));
    }

    @Override
    public void onAfterLoad(DBObject dbo) {
        this.log.info((Object)("onAfterLoad: " + dbo));
    }

    public void onAfterConvert(DBObject dbo, Object source) {
        this.log.info((Object)("onAfterConvert: " + dbo + ", " + source));
    }
}

