/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.document.mongodb.monitor;

import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.document.mongodb.MongoDbUtils;

public abstract class AbstractMonitor {
    private final Log logger = LogFactory.getLog(this.getClass());
    protected Mongo mongo;
    private String username;
    private String password;

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public CommandResult getServerStatus() {
        CommandResult result = this.getDb("admin").command("serverStatus");
        if (!result.ok()) {
            this.logger.error((Object)("Could not query for server status.  Command Result = " + result));
            throw new MongoException("could not query for server status.  Command Result = " + result);
        }
        return result;
    }

    public DB getDb(String databaseName) {
        return MongoDbUtils.getDB(this.mongo, databaseName, this.username, this.password == null ? null : this.password.toCharArray());
    }
}

