/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.document.mongodb.monitor;

import com.mongodb.DBObject;
import com.mongodb.Mongo;
import org.springframework.data.document.mongodb.monitor.AbstractMonitor;
import org.springframework.jmx.export.annotation.ManagedMetric;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.jmx.support.MetricType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagedResource(description="Memory Metrics")
public class MemoryMetrics
extends AbstractMonitor {
    public MemoryMetrics(Mongo mongo) {
        this.mongo = mongo;
    }

    @ManagedMetric(metricType=MetricType.COUNTER, displayName="Memory address size")
    public int getBits() {
        return this.getMemData("bits", Integer.class);
    }

    @ManagedMetric(metricType=MetricType.GAUGE, displayName="Resident in Physical Memory", unit="MB")
    public int getResidentSpace() {
        return this.getMemData("resident", Integer.class);
    }

    @ManagedMetric(metricType=MetricType.GAUGE, displayName="Virtual Address Space", unit="MB")
    public int getVirtualAddressSpace() {
        return this.getMemData("virtual", Integer.class);
    }

    @ManagedMetric(metricType=MetricType.GAUGE, displayName="Is memory info supported on this platform")
    public boolean getMemoryInfoSupported() {
        return this.getMemData("supported", Boolean.class);
    }

    @ManagedMetric(metricType=MetricType.GAUGE, displayName="Memory Mapped Space", unit="MB")
    public int getMemoryMappedSpace() {
        return this.getMemData("mapped", Integer.class);
    }

    private <T> T getMemData(String key, Class<T> targetClass) {
        DBObject mem = (DBObject)this.getServerStatus().get("mem");
        return (T)mem.get(key);
    }
}

