/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.document.mongodb.query;

import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import org.bson.BSONObject;
import org.springframework.data.document.mongodb.query.Criteria;
import org.springframework.data.document.mongodb.query.Query;

public class BasicQuery
extends Query {
    private DBObject queryObject = null;
    private DBObject fieldsObject = null;
    private DBObject sortObject = null;
    private int skip;
    private int limit;

    public BasicQuery(String query) {
        this.queryObject = (DBObject)JSON.parse((String)query);
    }

    public BasicQuery(DBObject queryObject) {
        this.queryObject = queryObject;
    }

    public BasicQuery(String query, String fields) {
        this.queryObject = (DBObject)JSON.parse((String)query);
        this.fieldsObject = (DBObject)JSON.parse((String)fields);
    }

    public BasicQuery(DBObject queryObject, DBObject fieldsObject) {
        this.queryObject = queryObject;
        this.fieldsObject = fieldsObject;
    }

    public Query addCriteria(Criteria criteria) {
        this.queryObject.putAll((BSONObject)criteria.getCriteriaObject());
        return this;
    }

    public DBObject getQueryObject() {
        return this.queryObject;
    }

    public DBObject getFieldsObject() {
        return this.fieldsObject;
    }

    public DBObject getSortObject() {
        return this.sortObject;
    }

    public void setSortObject(DBObject sortObject) {
        this.sortObject = sortObject;
    }

    public int getSkip() {
        return this.skip;
    }

    public void setSkip(int skip) {
        this.skip = skip;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }
}

