/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.document.mongodb.query;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import java.util.Collections;
import org.springframework.data.document.mongodb.query.Update;

public class BasicUpdate
extends Update {
    private DBObject updateObject = null;

    public BasicUpdate(String updateString) {
        this.updateObject = (DBObject)JSON.parse((String)updateString);
    }

    public BasicUpdate(DBObject updateObject) {
        this.updateObject = updateObject;
    }

    public Update set(String key, Object value) {
        this.updateObject.put("$set", Collections.singletonMap(key, value));
        return this;
    }

    public Update unset(String key) {
        this.updateObject.put("$unset", Collections.singletonMap(key, 1));
        return this;
    }

    public Update inc(String key, Number inc) {
        this.updateObject.put("$inc", Collections.singletonMap(key, inc));
        return this;
    }

    public Update push(String key, Object value) {
        this.updateObject.put("$push", Collections.singletonMap(key, value));
        return this;
    }

    public Update pushAll(String key, Object[] values) {
        BasicDBObject keyValue = new BasicDBObject();
        keyValue.put(key, (Object)values);
        this.updateObject.put("$pushAll", (Object)keyValue);
        return this;
    }

    public Update addToSet(String key, Object value) {
        this.updateObject.put("$addToSet", Collections.singletonMap(key, value));
        return this;
    }

    public Update pop(String key, Update.Position pos) {
        this.updateObject.put("$pop", Collections.singletonMap(key, pos == Update.Position.FIRST ? -1 : 1));
        return this;
    }

    public Update pull(String key, Object value) {
        this.updateObject.put("$pull", Collections.singletonMap(key, value));
        return this;
    }

    public Update pullAll(String key, Object[] values) {
        Object[] convertedValues = new Object[values.length];
        for (int i = 0; i < values.length; ++i) {
            convertedValues[i] = values[i];
        }
        BasicDBObject keyValue = new BasicDBObject();
        keyValue.put(key, (Object)convertedValues);
        this.updateObject.put("$pullAll", (Object)keyValue);
        return this;
    }

    public Update rename(String oldName, String newName) {
        this.updateObject.put("$rename", Collections.singletonMap(oldName, newName));
        return this;
    }

    public DBObject getUpdateObject() {
        return this.updateObject;
    }
}

