/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.document.mongodb.query;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.bson.BSONObject;
import org.springframework.data.document.mongodb.InvalidMongoDbApiUsageException;
import org.springframework.data.document.mongodb.geo.Box;
import org.springframework.data.document.mongodb.geo.Circle;
import org.springframework.data.document.mongodb.geo.Point;
import org.springframework.data.document.mongodb.query.CriteriaDefinition;
import org.springframework.data.document.mongodb.query.Query;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Criteria
implements CriteriaDefinition {
    private static final Object NOT_SET = new Object();
    private String key;
    private List<Criteria> criteriaChain;
    private LinkedHashMap<String, Object> criteria = new LinkedHashMap();
    private Object isValue = NOT_SET;

    public Criteria(String key) {
        this.criteriaChain = new ArrayList<Criteria>();
        this.criteriaChain.add(this);
        this.key = key;
    }

    protected Criteria(List<Criteria> criteriaChain, String key) {
        this.criteriaChain = criteriaChain;
        this.criteriaChain.add(this);
        this.key = key;
    }

    public static Criteria where(String key) {
        return new Criteria(key);
    }

    public Criteria and(String key) {
        return new Criteria(this.criteriaChain, key);
    }

    public Criteria is(Object o) {
        if (this.isValue != NOT_SET) {
            throw new InvalidMongoDbApiUsageException("Multiple 'is' values declared. You need to use 'and' with multiple criteria");
        }
        if (this.criteria.size() > 0 && "$not".equals(this.criteria.keySet().toArray()[this.criteria.size() - 1])) {
            throw new InvalidMongoDbApiUsageException("Invalid query: 'not' can't be used with 'is' - use 'ne' instead.");
        }
        this.isValue = o;
        return this;
    }

    public Criteria ne(Object o) {
        this.criteria.put("$ne", o);
        return this;
    }

    public Criteria lt(Object o) {
        this.criteria.put("$lt", o);
        return this;
    }

    public Criteria lte(Object o) {
        this.criteria.put("$lte", o);
        return this;
    }

    public Criteria gt(Object o) {
        this.criteria.put("$gt", o);
        return this;
    }

    public Criteria gte(Object o) {
        this.criteria.put("$gte", o);
        return this;
    }

    public Criteria in(Object ... o) {
        if (o.length > 1 && o[1] instanceof Collection) {
            throw new InvalidMongoDbApiUsageException("You can only pass in one argument of type " + o[1].getClass().getName());
        }
        this.criteria.put("$in", o);
        return this;
    }

    public Criteria in(Collection<?> c) {
        System.out.println(c.getClass());
        this.criteria.put("$in", c.toArray());
        return this;
    }

    public Criteria nin(Object ... o) {
        this.criteria.put("$nin", o);
        return this;
    }

    public Criteria mod(Number value, Number remainder) {
        ArrayList<Number> l = new ArrayList<Number>();
        l.add(value);
        l.add(remainder);
        this.criteria.put("$mod", l);
        return this;
    }

    public Criteria all(Object ... o) {
        this.criteria.put("$all", o);
        return this;
    }

    public Criteria size(int s) {
        this.criteria.put("$size", s);
        return this;
    }

    public Criteria exists(boolean b) {
        this.criteria.put("$exists", b);
        return this;
    }

    public Criteria type(int t) {
        this.criteria.put("$type", t);
        return this;
    }

    public Criteria not() {
        this.criteria.put("$not", null);
        return this;
    }

    public Criteria regex(String re) {
        this.criteria.put("$regex", re);
        return this;
    }

    public Criteria regex(String re, String options) {
        this.criteria.put("$regex", re);
        if (StringUtils.hasText((String)options)) {
            this.criteria.put("$options", options);
        }
        return this;
    }

    public Criteria withinCenter(Circle circle) {
        Assert.notNull((Object)circle);
        LinkedList<Object> list = new LinkedList<Object>();
        list.addLast(circle.getCenter().asArray());
        list.add(circle.getRadius());
        this.criteria.put("$within", new BasicDBObject("$center", list));
        return this;
    }

    public Criteria withinCenterSphere(Circle circle) {
        Assert.notNull((Object)circle);
        LinkedList<Object> list = new LinkedList<Object>();
        list.addLast(circle.getCenter().asArray());
        list.add(circle.getRadius());
        this.criteria.put("$within", new BasicDBObject("$centerSphere", list));
        return this;
    }

    public Criteria withinBox(Box box) {
        Assert.notNull((Object)box);
        LinkedList<double[]> list = new LinkedList<double[]>();
        list.addLast(box.getLowerLeft().asArray());
        list.addLast(box.getUpperRight().asArray());
        this.criteria.put("$within", new BasicDBObject("$box", list));
        return this;
    }

    public Criteria near(Point point) {
        Assert.notNull((Object)point);
        this.criteria.put("$near", point.asArray());
        return this;
    }

    public Criteria nearSphere(Point point) {
        Assert.notNull((Object)point);
        this.criteria.put("$nearSphere", point.asArray());
        return this;
    }

    public Criteria maxDistance(double maxDistance) {
        this.criteria.put("$maxDistance", maxDistance);
        return this;
    }

    public Criteria elemMatch(Criteria c) {
        this.criteria.put("$elemMatch", c.getCriteriaObject());
        return this;
    }

    public void or(List<Query> queries) {
        this.criteria.put("$or", queries);
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public DBObject getCriteriaObject() {
        if (this.criteriaChain.size() == 1) {
            return this.criteriaChain.get(0).getSingleCriteriaObject();
        }
        BasicDBObject criteriaObject = new BasicDBObject();
        for (Criteria c : this.criteriaChain) {
            criteriaObject.putAll((BSONObject)c.getSingleCriteriaObject());
        }
        return criteriaObject;
    }

    protected DBObject getSingleCriteriaObject() {
        BasicDBObject dbo = new BasicDBObject();
        boolean not = false;
        for (String k : this.criteria.keySet()) {
            if (not) {
                BasicDBObject notDbo = new BasicDBObject();
                notDbo.put(k, this.criteria.get(k));
                dbo.put("$not", (Object)notDbo);
                not = false;
                continue;
            }
            if ("$not".equals(k)) {
                not = true;
                continue;
            }
            dbo.put(k, this.criteria.get(k));
        }
        BasicDBObject queryCriteria = new BasicDBObject();
        if (this.isValue != NOT_SET) {
            queryCriteria.put(this.key, this.isValue);
            queryCriteria.putAll((BSONObject)dbo);
        } else {
            queryCriteria.put(this.key, (Object)dbo);
        }
        return queryCriteria;
    }
}

