/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.document.mongodb.query;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.HashMap;
import java.util.Map;

public class Field {
    private Map<String, Integer> criteria = new HashMap<String, Integer>();
    private Map<String, Object> slices = new HashMap<String, Object>();

    public Field include(String key) {
        this.criteria.put(key, 1);
        return this;
    }

    public Field exclude(String key) {
        this.criteria.put(key, 0);
        return this;
    }

    public Field slice(String key, int size) {
        this.slices.put(key, size);
        return this;
    }

    public Field slice(String key, int offset, int size) {
        this.slices.put(key, new Integer[]{offset, size});
        return this;
    }

    public DBObject getFieldsObject() {
        BasicDBObject dbo = new BasicDBObject();
        for (String k : this.criteria.keySet()) {
            dbo.put(k, (Object)this.criteria.get(k));
        }
        for (String k : this.slices.keySet()) {
            dbo.put(k, (Object)new BasicDBObject("$slice", this.slices.get(k)));
        }
        return dbo;
    }
}

