/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.document.mongodb.query;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.HashMap;
import java.util.Map;
import org.springframework.data.document.mongodb.index.IndexDefinition;
import org.springframework.data.document.mongodb.query.Order;

public class Index
implements IndexDefinition {
    private Map<String, Order> fieldSpec = new HashMap<String, Order>();
    private String name;
    private boolean unique = false;
    private boolean dropDuplicates = false;
    private boolean sparse = false;

    public Index() {
    }

    public Index(String key, Order order) {
        this.fieldSpec.put(key, order);
    }

    public Index on(String key, Order order) {
        this.fieldSpec.put(key, order);
        return this;
    }

    public Index named(String name) {
        this.name = name;
        return this;
    }

    public Index unique() {
        this.unique = true;
        return this;
    }

    public Index sparse() {
        this.sparse = true;
        return this;
    }

    public Index unique(Duplicates duplicates) {
        if (duplicates == Duplicates.DROP) {
            this.dropDuplicates = true;
        }
        return this.unique();
    }

    public DBObject getIndexKeys() {
        BasicDBObject dbo = new BasicDBObject();
        for (String k : this.fieldSpec.keySet()) {
            dbo.put(k, (Object)(this.fieldSpec.get(k).equals((Object)Order.ASCENDING) ? 1 : -1));
        }
        return dbo;
    }

    public DBObject getIndexOptions() {
        if (this.name == null && !this.unique) {
            return null;
        }
        BasicDBObject dbo = new BasicDBObject();
        if (this.name != null) {
            dbo.put("name", (Object)this.name);
        }
        if (this.unique) {
            dbo.put("unique", (Object)true);
        }
        if (this.dropDuplicates) {
            dbo.put("dropDups", (Object)true);
        }
        if (this.sparse) {
            dbo.put("sparse", (Object)true);
        }
        return dbo;
    }

    public String toString() {
        return String.format("Index: %s - Options: %s", this.getIndexKeys(), this.getIndexOptions());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Duplicates {
        RETAIN,
        DROP;

    }
}

