/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.document.mongodb.query;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Iterator;
import org.bson.types.BasicBSONList;
import org.bson.types.ObjectId;
import org.springframework.core.convert.ConversionException;
import org.springframework.data.document.mongodb.convert.MongoConverter;
import org.springframework.data.document.mongodb.mapping.MongoPersistentEntity;
import org.springframework.data.document.mongodb.mapping.MongoPersistentProperty;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryMapper {
    private final MongoConverter converter;

    public QueryMapper(MongoConverter converter) {
        Assert.notNull((Object)converter);
        this.converter = converter;
    }

    public DBObject getMappedObject(DBObject query, MongoPersistentEntity<?> entity) {
        String idKey = null;
        if (null != entity && entity.getIdProperty() != null) {
            idKey = ((MongoPersistentProperty)entity.getIdProperty()).getName();
        } else if (query.containsField("id")) {
            idKey = "id";
        } else if (query.containsField("_id")) {
            idKey = "_id";
        }
        BasicDBObject newDbo = new BasicDBObject();
        Iterator i$ = query.keySet().iterator();
        while (i$.hasNext()) {
            String key;
            String newKey = key = (String)i$.next();
            Object value = query.get(key);
            if (key.equals(idKey)) {
                if (value instanceof DBObject) {
                    DBObject valueDbo = (DBObject)value;
                    if (valueDbo.containsField("$in") || valueDbo.containsField("$nin")) {
                        String inKey = valueDbo.containsField("$in") ? "$in" : "$nin";
                        ArrayList<Object> ids = new ArrayList<Object>();
                        for (Object id : (Object[])valueDbo.get(inKey)) {
                            if (null != this.converter && !(id instanceof ObjectId)) {
                                try {
                                    ObjectId oid = this.converter.convertObjectId(id);
                                    ids.add(oid);
                                }
                                catch (ConversionException ignored) {
                                    ids.add(id);
                                }
                                continue;
                            }
                            ids.add(id);
                        }
                        valueDbo.put(inKey, (Object)ids.toArray(new Object[ids.size()]));
                    } else {
                        value = this.getMappedObject((DBObject)value, entity);
                    }
                } else if (null != this.converter) {
                    try {
                        value = this.converter.convertObjectId(value);
                    }
                    catch (ConversionException ignored) {
                        // empty catch block
                    }
                }
                newKey = "_id";
            } else if (key.startsWith("$") && key.endsWith("or")) {
                BasicBSONList conditions = (BasicBSONList)value;
                BasicBSONList newConditions = new BasicBSONList();
                Iterator iter = conditions.iterator();
                while (iter.hasNext()) {
                    newConditions.add((Object)this.getMappedObject((DBObject)iter.next(), entity));
                }
                value = newConditions;
            }
            newDbo.put(newKey, value);
        }
        return newDbo;
    }
}

