/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.document.mongodb.repository;

import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.List;
import org.springframework.data.document.mongodb.CollectionCallback;
import org.springframework.data.document.mongodb.MongoTemplate;
import org.springframework.data.document.mongodb.query.Query;
import org.springframework.data.document.mongodb.repository.ConvertingParameterAccessor;
import org.springframework.data.document.mongodb.repository.MongoEntityInformation;
import org.springframework.data.document.mongodb.repository.MongoQueryMethod;
import org.springframework.data.document.mongodb.repository.QueryUtils;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.util.Assert;

public abstract class AbstractMongoQuery
implements RepositoryQuery {
    private final MongoQueryMethod method;
    private final MongoTemplate template;

    public AbstractMongoQuery(MongoQueryMethod method, MongoTemplate template) {
        Assert.notNull((Object)template);
        Assert.notNull((Object)((Object)method));
        this.method = method;
        this.template = template;
    }

    public MongoQueryMethod getQueryMethod() {
        return this.method;
    }

    public Object execute(Object[] parameters) {
        ParametersParameterAccessor accessor = new ParametersParameterAccessor(this.method.getParameters(), parameters);
        Query query = this.createQuery(new ConvertingParameterAccessor(this.template.getConverter(), (ParameterAccessor)accessor));
        switch (this.method.getType()) {
            case COLLECTION: {
                return new CollectionExecution().execute(query);
            }
            case PAGING: {
                return new PagedExecution(accessor.getPageable()).execute(query);
            }
        }
        return new SingleEntityExecution().execute(query);
    }

    protected abstract Query createQuery(ConvertingParameterAccessor var1);

    class SingleEntityExecution
    extends Execution {
        SingleEntityExecution() {
        }

        Object execute(Query query) {
            List<?> result = this.readCollection(query);
            return result.isEmpty() ? null : result.get(0);
        }
    }

    class PagedExecution
    extends Execution {
        private final Pageable pageable;

        public PagedExecution(Pageable pageable) {
            Assert.notNull((Object)pageable);
            this.pageable = pageable;
        }

        Object execute(Query query) {
            MongoEntityInformation<?, ?> metadata = AbstractMongoQuery.this.method.getEntityInformation();
            int count = this.getCollectionCursor(metadata.getCollectionName(), query.getQueryObject()).count();
            List result = AbstractMongoQuery.this.template.find(QueryUtils.applyPagination(query, this.pageable), metadata.getJavaType(), metadata.getCollectionName());
            return new PageImpl(result, this.pageable, (long)count);
        }

        private DBCursor getCollectionCursor(String collectionName, final DBObject query) {
            return AbstractMongoQuery.this.template.execute(collectionName, new CollectionCallback<DBCursor>(){

                @Override
                public DBCursor doInCollection(DBCollection collection) {
                    return collection.find(query);
                }
            });
        }
    }

    class CollectionExecution
    extends Execution {
        CollectionExecution() {
        }

        public Object execute(Query query) {
            return this.readCollection(query);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class Execution {
        private Execution() {
        }

        abstract Object execute(Query var1);

        protected List<?> readCollection(Query query) {
            MongoEntityInformation<?, ?> metadata = AbstractMongoQuery.this.method.getEntityInformation();
            String collectionName = metadata.getCollectionName();
            return AbstractMongoQuery.this.template.find(query, metadata.getJavaType(), collectionName);
        }
    }
}

