/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.document.mongodb.repository;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.springframework.data.document.mongodb.MongoWriter;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.ParameterAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertingParameterAccessor
implements ParameterAccessor {
    private final MongoWriter<Object> writer;
    private final ParameterAccessor delegate;

    public ConvertingParameterAccessor(MongoWriter<Object> writer, ParameterAccessor delegate) {
        this.writer = writer;
        this.delegate = delegate;
    }

    public Iterator<Object> iterator() {
        return new ConvertingIterator(this.delegate.iterator());
    }

    public Pageable getPageable() {
        return this.delegate.getPageable();
    }

    public Sort getSort() {
        return this.delegate.getSort();
    }

    public Object getBindableValue(int index) {
        return this.getConvertedValue(this.delegate.getBindableValue(index));
    }

    private Object getConvertedValue(Object value) {
        BasicDBObject result = new BasicDBObject();
        this.writer.write(new ValueHolder(value), (DBObject)result);
        Object resultValue = ((DBObject)result.get("value")).get("value");
        return this.removeTypeInfoRecursively(resultValue);
    }

    private Object removeTypeInfoRecursively(Object object) {
        if (!(object instanceof DBObject)) {
            return object;
        }
        DBObject dbObject = (DBObject)object;
        dbObject.removeField("_class");
        for (String key : dbObject.keySet()) {
            Object value = dbObject.get(key);
            if (value instanceof BasicDBList) {
                for (Object element : (BasicDBList)value) {
                    this.removeTypeInfoRecursively(element);
                }
                continue;
            }
            this.removeTypeInfoRecursively(value);
        }
        return dbObject;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface PotentiallyConvertingIterator
    extends Iterator<Object> {
        public Object nextConverted();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ValueHolder {
        private Map<String, Object> value = new HashMap<String, Object>();

        public ValueHolder(Object value) {
            this.value.put("value", value);
        }

        public Map<String, Object> getValue() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConvertingIterator
    implements PotentiallyConvertingIterator {
        private final Iterator<Object> delegate;

        public ConvertingIterator(Iterator<Object> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public Object next() {
            return this.delegate.next();
        }

        @Override
        public Object nextConverted() {
            return ConvertingParameterAccessor.this.getConvertedValue(this.next());
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }
    }
}

