/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.document.mongodb.repository;

import java.io.Serializable;
import org.springframework.data.document.mongodb.mapping.MongoPersistentEntity;
import org.springframework.data.document.mongodb.mapping.MongoPersistentProperty;
import org.springframework.data.document.mongodb.repository.MongoEntityInformation;
import org.springframework.data.mapping.BeanWrapper;
import org.springframework.data.mapping.model.PersistentProperty;
import org.springframework.data.repository.support.AbstractEntityInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingMongoEntityInformation<T, ID extends Serializable>
extends AbstractEntityInformation<T, ID>
implements MongoEntityInformation<T, ID> {
    private final MongoPersistentEntity<T> entityMetadata;

    public MappingMongoEntityInformation(MongoPersistentEntity<T> entity) {
        super(entity.getType());
        this.entityMetadata = entity;
    }

    public ID getId(T entity) {
        MongoPersistentProperty idProperty = (MongoPersistentProperty)this.entityMetadata.getIdProperty();
        try {
            return (ID)((Serializable)BeanWrapper.create(entity, null).getProperty((PersistentProperty)idProperty));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Class<ID> getIdType() {
        return ((MongoPersistentProperty)this.entityMetadata.getIdProperty()).getType();
    }

    @Override
    public String getCollectionName() {
        return this.entityMetadata.getCollection();
    }

    @Override
    public String getIdAttribute() {
        return ((MongoPersistentProperty)this.entityMetadata.getIdProperty()).getName();
    }
}

