/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.document.mongodb.repository;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.document.mongodb.repository.MongoEntityInformation;
import org.springframework.data.document.mongodb.repository.MongoRepositoryFactoryBean;
import org.springframework.data.document.mongodb.repository.Query;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.support.RepositoryMetadata;
import org.springframework.data.repository.util.ClassUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MongoQueryMethod
extends QueryMethod {
    private final Method method;
    private final MongoEntityInformation<?, ?> entityInformation;

    public MongoQueryMethod(Method method, RepositoryMetadata metadata, MongoRepositoryFactoryBean.EntityInformationCreator entityInformationCreator) {
        super(method, metadata);
        this.method = method;
        this.entityInformation = entityInformationCreator.getEntityInformation(ClassUtils.getReturnedDomainClass((Method)method));
    }

    boolean hasAnnotatedQuery() {
        return this.getAnnotatedQuery() != null;
    }

    String getAnnotatedQuery() {
        String query = (String)AnnotationUtils.getValue((Annotation)this.getQueryAnnotation());
        return StringUtils.hasText((String)query) ? query : null;
    }

    String getFieldSpecification() {
        String value = (String)AnnotationUtils.getValue((Annotation)this.getQueryAnnotation(), (String)"fields");
        return StringUtils.hasText((String)value) ? value : null;
    }

    public MongoEntityInformation<?, ?> getEntityInformation() {
        return this.entityInformation;
    }

    private Query getQueryAnnotation() {
        return this.method.getAnnotation(Query.class);
    }
}

