/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.document.mongodb.repository;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.document.mongodb.MongoOperations;
import org.springframework.data.document.mongodb.MongoPropertyDescriptors;
import org.springframework.data.document.mongodb.MongoTemplate;
import org.springframework.data.document.mongodb.index.IndexDefinition;
import org.springframework.data.document.mongodb.mapping.MongoPersistentEntity;
import org.springframework.data.document.mongodb.mapping.MongoPersistentProperty;
import org.springframework.data.document.mongodb.query.Index;
import org.springframework.data.document.mongodb.query.Order;
import org.springframework.data.document.mongodb.repository.MappingMongoEntityInformation;
import org.springframework.data.document.mongodb.repository.MongoEntityInformation;
import org.springframework.data.document.mongodb.repository.MongoQueryMethod;
import org.springframework.data.document.mongodb.repository.PartTreeMongoQuery;
import org.springframework.data.document.mongodb.repository.QueryDslMongoRepository;
import org.springframework.data.document.mongodb.repository.SimpleMongoRepository;
import org.springframework.data.document.mongodb.repository.StringBasedMongoQuery;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.model.MappingContext;
import org.springframework.data.querydsl.QueryDslPredicateExecutor;
import org.springframework.data.querydsl.QueryDslUtils;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.data.repository.support.EntityInformation;
import org.springframework.data.repository.support.QueryCreationListener;
import org.springframework.data.repository.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.support.RepositoryFactorySupport;
import org.springframework.data.repository.support.RepositoryMetadata;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoRepositoryFactoryBean<T extends Repository<S, ID>, S, ID extends Serializable>
extends RepositoryFactoryBeanSupport<T, S, ID> {
    private MongoTemplate template;

    public void setTemplate(MongoTemplate template) {
        this.template = template;
    }

    protected RepositoryFactorySupport createRepositoryFactory() {
        MongoRepositoryFactory factory = new MongoRepositoryFactory(this.template);
        factory.addQueryCreationListener(new IndexEnsuringQueryCreationListener(this.template));
        return factory;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.template, (String)"MongoTemplate must not be null!");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IndexEnsuringQueryCreationListener
    implements QueryCreationListener<PartTreeMongoQuery> {
        private static final Set<Part.Type> GEOSPATIAL_TYPES = new HashSet<Part.Type>(Arrays.asList(Part.Type.NEAR, Part.Type.WITHIN));
        private static final Log LOG = LogFactory.getLog(IndexEnsuringQueryCreationListener.class);
        private final MongoOperations operations;

        public IndexEnsuringQueryCreationListener(MongoOperations operations) {
            this.operations = operations;
        }

        public void onCreation(PartTreeMongoQuery query) {
            PartTree tree = query.getTree();
            Index index = new Index();
            index.named(query.getQueryMethod().getName());
            Sort sort = tree.getSort();
            for (Part part : tree.getParts()) {
                if (GEOSPATIAL_TYPES.contains(part.getType())) {
                    return;
                }
                String property = part.getProperty().toDotPath();
                Order order = IndexEnsuringQueryCreationListener.toOrder(sort, property);
                index.on(property, order);
            }
            MongoEntityInformation<?, ?> metadata = query.getQueryMethod().getEntityInformation();
            this.operations.ensureIndex((IndexDefinition)index, metadata.getCollectionName());
            LOG.debug((Object)String.format("Created %s!", index));
        }

        private static Order toOrder(Sort sort, String property) {
            if (sort == null) {
                return Order.DESCENDING;
            }
            Sort.Order order = sort.getOrderFor(property);
            return order == null ? Order.DESCENDING : (order.isAscending() ? Order.ASCENDING : Order.DESCENDING);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class EntityInformationCreator {
        private final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;

        public EntityInformationCreator(MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext) {
            Assert.notNull(mappingContext);
            this.mappingContext = mappingContext;
        }

        public <T, ID extends Serializable> MongoEntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
            MongoPersistentEntity persistentEntity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(domainClass);
            return new MappingMongoEntityInformation(persistentEntity);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MongoRepositoryFactory
    extends RepositoryFactorySupport {
        private final MongoTemplate template;
        private final EntityInformationCreator entityInformationCreator;

        public MongoRepositoryFactory(MongoTemplate template) {
            Assert.notNull((Object)template);
            this.template = template;
            this.entityInformationCreator = new EntityInformationCreator(template.getConverter().getMappingContext());
        }

        protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
            return MongoRepositoryFactory.isQueryDslRepository(metadata.getRepositoryInterface()) ? QueryDslMongoRepository.class : SimpleMongoRepository.class;
        }

        protected Object getTargetRepository(RepositoryMetadata metadata) {
            Class repositoryInterface = metadata.getRepositoryInterface();
            EntityInformation entityInformation = this.getEntityInformation(metadata.getDomainClass());
            if (MongoRepositoryFactory.isQueryDslRepository(repositoryInterface)) {
                return new QueryDslMongoRepository(entityInformation, this.template);
            }
            return new SimpleMongoRepository(entityInformation, this.template);
        }

        private static boolean isQueryDslRepository(Class<?> repositoryInterface) {
            return QueryDslUtils.QUERY_DSL_PRESENT && QueryDslPredicateExecutor.class.isAssignableFrom(repositoryInterface);
        }

        protected QueryLookupStrategy getQueryLookupStrategy(QueryLookupStrategy.Key key) {
            return new MongoQueryLookupStrategy();
        }

        protected void validate(RepositoryMetadata metadata) {
            Class idClass = metadata.getIdClass();
            if (!MongoPropertyDescriptors.MongoPropertyDescriptor.SUPPORTED_ID_CLASSES.contains(idClass)) {
                throw new IllegalArgumentException(String.format("Unsupported id class! Only %s are supported!", StringUtils.collectionToCommaDelimitedString(MongoPropertyDescriptors.MongoPropertyDescriptor.SUPPORTED_ID_CLASSES)));
            }
        }

        public <T, ID extends Serializable> MongoEntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
            return this.entityInformationCreator.getEntityInformation(domainClass);
        }

        private class MongoQueryLookupStrategy
        implements QueryLookupStrategy {
            private MongoQueryLookupStrategy() {
            }

            public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata) {
                MongoQueryMethod queryMethod = new MongoQueryMethod(method, metadata, MongoRepositoryFactory.this.entityInformationCreator);
                if (queryMethod.hasAnnotatedQuery()) {
                    return new StringBasedMongoQuery(queryMethod, MongoRepositoryFactory.this.template);
                }
                return new PartTreeMongoQuery(queryMethod, MongoRepositoryFactory.this.template);
            }
        }
    }
}

