/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.document.mongodb.repository;

import com.mongodb.DBObject;
import com.mysema.query.mongodb.MongodbQuery;
import com.mysema.query.mongodb.MongodbSerializer;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Order;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.path.PathBuilder;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.collections15.Transformer;
import org.springframework.data.document.mongodb.MongoOperations;
import org.springframework.data.document.mongodb.MongoTemplate;
import org.springframework.data.document.mongodb.convert.MongoConverter;
import org.springframework.data.document.mongodb.repository.MongoEntityInformation;
import org.springframework.data.document.mongodb.repository.SimpleMongoRepository;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.querydsl.EntityPathResolver;
import org.springframework.data.querydsl.QueryDslPredicateExecutor;
import org.springframework.data.querydsl.SimpleEntityPathResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryDslMongoRepository<T, ID extends Serializable>
extends SimpleMongoRepository<T, ID>
implements QueryDslPredicateExecutor<T> {
    private final MongoConverterTransformer transformer;
    private final MongodbSerializer serializer;
    private final PathBuilder<T> builder;

    public QueryDslMongoRepository(MongoEntityInformation<T, ID> entityInformation, MongoTemplate template) {
        this(entityInformation, template, (EntityPathResolver)SimpleEntityPathResolver.INSTANCE);
    }

    public QueryDslMongoRepository(MongoEntityInformation<T, ID> entityInformation, MongoTemplate template, EntityPathResolver resolver) {
        super(entityInformation, template);
        this.transformer = new MongoConverterTransformer(template.getConverter());
        this.serializer = new MongodbSerializer();
        EntityPath path = resolver.createPath(entityInformation.getJavaType());
        this.builder = new PathBuilder(path.getType(), path.getMetadata());
    }

    @Override
    public T findOne(Predicate predicate) {
        return (T)this.createQueryFor(predicate).uniqueResult();
    }

    public List<T> findAll(Predicate predicate) {
        return this.createQueryFor(predicate).list();
    }

    public List<T> findAll(Predicate predicate, OrderSpecifier<?> ... orders) {
        return this.createQueryFor(predicate).orderBy(orders).list();
    }

    public Page<T> findAll(Predicate predicate, Pageable pageable) {
        MongodbQuery<T> countQuery = this.createQueryFor(predicate);
        MongodbQuery<T> query = this.createQueryFor(predicate);
        return new PageImpl(this.applyPagination(query, pageable).list(), pageable, countQuery.count());
    }

    public long count(Predicate predicate) {
        return this.createQueryFor(predicate).count();
    }

    private MongodbQuery<T> createQueryFor(Predicate predicate) {
        MongoTemplateQuery query = new MongoTemplateQuery(this.getMongoOperations());
        return query.where(new Predicate[]{predicate});
    }

    private MongodbQuery<T> applyPagination(MongodbQuery<T> query, Pageable pageable) {
        if (pageable == null) {
            return query;
        }
        query = query.offset((long)pageable.getOffset()).limit((long)pageable.getPageSize());
        return this.applySorting(query, pageable.getSort());
    }

    private MongodbQuery<T> applySorting(MongodbQuery<T> query, Sort sort) {
        if (sort == null) {
            return query;
        }
        for (Sort.Order order : sort) {
            query.orderBy(new OrderSpecifier[]{this.toOrder(order)});
        }
        return query;
    }

    private OrderSpecifier<?> toOrder(Sort.Order order) {
        PathBuilder property = this.builder.get(order.getProperty());
        return new OrderSpecifier(order.isAscending() ? Order.ASC : Order.DESC, (Expression)property);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MongoConverterTransformer
    implements Transformer<DBObject, T> {
        private final MongoConverter converter;

        public MongoConverterTransformer(MongoConverter converter) {
            this.converter = converter;
        }

        public T transform(DBObject input) {
            return this.converter.read(QueryDslMongoRepository.this.getEntityInformation().getJavaType(), input);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MongoTemplateQuery
    extends MongodbQuery<T> {
        public MongoTemplateQuery(MongoOperations operations) {
            super(operations.getCollection(QueryDslMongoRepository.this.getEntityInformation().getCollectionName()), (Transformer)QueryDslMongoRepository.this.transformer, QueryDslMongoRepository.this.serializer);
        }
    }
}

