/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.document.mongodb.repository;

import org.springframework.data.document.mongodb.query.Order;
import org.springframework.data.document.mongodb.query.Query;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

abstract class QueryUtils {
    private QueryUtils() {
    }

    public static Query applyPagination(Query query, Pageable pageable) {
        if (pageable == null) {
            return query;
        }
        query.limit(pageable.getPageSize());
        query.skip(pageable.getOffset());
        return QueryUtils.applySorting(query, pageable.getSort());
    }

    public static Query applySorting(Query query, Sort sort) {
        if (sort == null) {
            return query;
        }
        org.springframework.data.document.mongodb.query.Sort bSort = query.sort();
        for (Sort.Order order : sort) {
            bSort.on(order.getProperty(), order.isAscending() ? Order.ASCENDING : Order.DESCENDING);
        }
        return query;
    }
}

