/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.document.mongodb.repository;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.dao.DataAccessException;
import org.springframework.data.document.mongodb.CollectionCallback;
import org.springframework.data.document.mongodb.MongoOperations;
import org.springframework.data.document.mongodb.MongoTemplate;
import org.springframework.data.document.mongodb.query.Criteria;
import org.springframework.data.document.mongodb.query.Query;
import org.springframework.data.document.mongodb.repository.MongoEntityInformation;
import org.springframework.data.document.mongodb.repository.QueryUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleMongoRepository<T, ID extends Serializable>
implements PagingAndSortingRepository<T, ID> {
    private final MongoTemplate template;
    private final MongoEntityInformation<T, ID> entityInformation;

    public SimpleMongoRepository(MongoEntityInformation<T, ID> metadata, MongoTemplate template) {
        Assert.notNull((Object)template);
        Assert.notNull(metadata);
        this.entityInformation = metadata;
        this.template = template;
    }

    public T save(T entity) {
        this.template.save(entity, this.entityInformation.getCollectionName());
        return entity;
    }

    public List<T> save(Iterable<? extends T> entities) {
        ArrayList<T> result = new ArrayList<T>();
        for (T entity : entities) {
            this.save(entity);
            result.add(entity);
        }
        return result;
    }

    public T findOne(ID id) {
        return this.template.findById(id, this.entityInformation.getJavaType());
    }

    private Query getIdQuery(Object id) {
        return new Query(this.getIdCriteria(id));
    }

    private Criteria getIdCriteria(Object id) {
        return Criteria.where(this.entityInformation.getIdAttribute()).is(id);
    }

    public boolean exists(final ID id) {
        return this.template.execute(this.entityInformation.getCollectionName(), new CollectionCallback<Boolean>(){

            @Override
            public Boolean doInCollection(DBCollection collection) throws MongoException, DataAccessException {
                return collection.count((DBObject)new BasicDBObject("_id", (Object)id)) > 0L;
            }
        });
    }

    public long count() {
        return this.template.getCollection(this.entityInformation.getCollectionName()).count();
    }

    public void delete(ID id) {
        this.template.remove(this.getIdQuery(id), this.entityInformation.getJavaType());
    }

    public void delete(T entity) {
        this.delete((T)this.entityInformation.getId(entity));
    }

    public void delete(Iterable<? extends T> entities) {
        for (T entity : entities) {
            this.delete(entity);
        }
    }

    public void deleteAll() {
        this.template.remove(new Query(), this.entityInformation.getCollectionName());
    }

    public List<T> findAll() {
        return this.findAll(new Query());
    }

    public Page<T> findAll(Pageable pageable) {
        Long count = this.count();
        List<T> list = this.findAll(QueryUtils.applyPagination(new Query(), pageable));
        return new PageImpl(list, pageable, count.longValue());
    }

    public List<T> findAll(Sort sort) {
        return this.findAll(QueryUtils.applySorting(new Query(), sort));
    }

    public List<T> findAll(Iterable<ID> ids) {
        Query query = null;
        for (Serializable id : ids) {
            if (query == null) {
                query = this.getIdQuery(id);
                continue;
            }
            query = new Query().or(this.getIdQuery(id));
        }
        return this.findAll(query);
    }

    private List<T> findAll(Query query) {
        if (query == null) {
            return Collections.emptyList();
        }
        return this.template.find(query, this.entityInformation.getJavaType(), this.entityInformation.getCollectionName());
    }

    protected MongoOperations getMongoOperations() {
        return this.template;
    }

    protected MongoEntityInformation<T, ID> getEntityInformation() {
        return this.entityInformation;
    }
}

