/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.bson.types.BasicBSONList;
import org.bson.types.ObjectId;
import org.springframework.core.convert.ConversionException;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryMapper {
    private final ConversionService conversionService;

    public QueryMapper(ConversionService conversionService) {
        Assert.notNull((Object)conversionService);
        this.conversionService = conversionService;
    }

    public DBObject getMappedObject(DBObject query, MongoPersistentEntity<?> entity) {
        String idKey = null;
        if (null != entity && entity.getIdProperty() != null) {
            idKey = ((MongoPersistentProperty)entity.getIdProperty()).getName();
        } else if (query.containsField("id")) {
            idKey = "id";
        } else if (query.containsField("_id")) {
            idKey = "_id";
        }
        BasicDBObject newDbo = new BasicDBObject();
        Iterator i$ = query.keySet().iterator();
        while (i$.hasNext()) {
            String key;
            String newKey = key = (String)i$.next();
            Object value = query.get(key);
            if (key.equals(idKey)) {
                if (value instanceof DBObject) {
                    DBObject valueDbo = (DBObject)value;
                    if (valueDbo.containsField("$in") || valueDbo.containsField("$nin")) {
                        String inKey = valueDbo.containsField("$in") ? "$in" : "$nin";
                        ArrayList<Object> ids = new ArrayList<Object>();
                        for (Object id : (Object[])valueDbo.get(inKey)) {
                            ids.add(this.convertId(id));
                        }
                        valueDbo.put(inKey, (Object)ids.toArray(new Object[ids.size()]));
                    } else {
                        value = this.getMappedObject((DBObject)value, entity);
                    }
                } else {
                    value = this.convertId(value);
                }
                newKey = "_id";
            } else if (key.startsWith("$") && key.endsWith("or")) {
                BasicBSONList conditions = (BasicBSONList)value;
                BasicBSONList newConditions = new BasicBSONList();
                Iterator iter = conditions.iterator();
                while (iter.hasNext()) {
                    newConditions.add((Object)this.getMappedObject((DBObject)iter.next(), entity));
                }
                value = newConditions;
            }
            newDbo.put(newKey, value);
        }
        return newDbo;
    }

    public Object convertId(Object id) {
        for (Class type : Arrays.asList(ObjectId.class, String.class)) {
            if (id.getClass().isAssignableFrom(type)) {
                return id;
            }
            try {
                return this.conversionService.convert(id, type);
            }
            catch (ConversionException e) {
            }
        }
        return id;
    }
}

