/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBObject;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.BSONObject;
import org.bson.types.ObjectId;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConversionException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.ConversionServiceFactory;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.AssociationHandler;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.BeanWrapper;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.mapping.model.SpELAwareParameterValueProvider;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.convert.AbstractMongoConverter;
import org.springframework.data.mongodb.core.convert.DefaultTypeMapper;
import org.springframework.data.mongodb.core.convert.TypeMapper;
import org.springframework.data.mongodb.core.convert.TypeMapperProvider;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingMongoConverter
extends AbstractMongoConverter
implements ApplicationContextAware,
TypeMapperProvider {
    private static final TypeInformation<Map> MAP_TYPE_INFORMATION = ClassTypeInformation.from(Map.class);
    private static final List<Class<?>> VALID_ID_TYPES = Arrays.asList(ObjectId.class, String.class, BigInteger.class, byte[].class);
    protected static final Log log = LogFactory.getLog(MappingMongoConverter.class);
    protected final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;
    protected final SpelExpressionParser spelExpressionParser = new SpelExpressionParser();
    protected final MongoDbFactory mongoDbFactory;
    protected ApplicationContext applicationContext;
    protected boolean useFieldAccessOnly = true;
    protected TypeMapper typeMapper = new DefaultTypeMapper();

    public MappingMongoConverter(MongoDbFactory mongoDbFactory, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext) {
        super(ConversionServiceFactory.createDefaultConversionService());
        Assert.notNull((Object)mongoDbFactory);
        Assert.notNull(mappingContext);
        this.mongoDbFactory = mongoDbFactory;
        this.mappingContext = mappingContext;
    }

    public void setTypeMapper(TypeMapper typeMapper) {
        this.typeMapper = typeMapper == null ? new DefaultTypeMapper() : typeMapper;
    }

    @Override
    public TypeMapper getTypeMapper() {
        return this.typeMapper;
    }

    @Override
    public MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> getMappingContext() {
        return this.mappingContext;
    }

    public void setUseFieldAccessOnly(boolean useFieldAccessOnly) {
        this.useFieldAccessOnly = useFieldAccessOnly;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public <S> S read(Class<S> clazz, DBObject dbo) {
        return this.read(ClassTypeInformation.from(clazz), dbo);
    }

    @Override
    protected <S> S read(TypeInformation<S> type, DBObject dbo) {
        if (null == dbo) {
            return null;
        }
        TypeInformation<S> typeToUse = this.getMoreConcreteTargetType(dbo, type);
        Class rawType = typeToUse.getType();
        if (this.conversions.hasCustomReadTarget(dbo.getClass(), rawType)) {
            return (S)this.conversionService.convert((Object)dbo, rawType);
        }
        if (typeToUse.isCollectionLike() && dbo instanceof BasicDBList) {
            return (S)this.readCollectionOrArray(typeToUse, (BasicDBList)dbo);
        }
        if (typeToUse.isMap()) {
            return (S)this.readMap(typeToUse, dbo);
        }
        MongoPersistentEntity persistentEntity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(typeToUse);
        if (persistentEntity == null) {
            throw new MappingException("No mapping metadata found for " + rawType.getName());
        }
        return this.read(persistentEntity, dbo);
    }

    @Override
    private <S> S read(MongoPersistentEntity<S> entity, final DBObject dbo) {
        final StandardEvaluationContext spelCtx = new StandardEvaluationContext();
        if (null != this.applicationContext) {
            spelCtx.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)this.applicationContext));
        }
        if (!(dbo instanceof BasicDBList)) {
            String[] keySet;
            for (String key : keySet = dbo.keySet().toArray(new String[0])) {
                spelCtx.setVariable(key, dbo.get(key));
            }
        }
        final ArrayList ctorParamNames = new ArrayList();
        final MongoPersistentProperty idProperty = (MongoPersistentProperty)entity.getIdProperty();
        SpELAwareParameterValueProvider provider = new SpELAwareParameterValueProvider(this.spelExpressionParser, (EvaluationContext)spelCtx){

            public <T> T getParameterValue(PreferredConstructor.Parameter<T> parameter) {
                if (parameter.getKey() != null) {
                    return (T)super.getParameterValue(parameter);
                }
                String name = parameter.getName();
                TypeInformation type = parameter.getType();
                Class rawType = parameter.getRawType();
                String key = idProperty == null ? name : (idProperty.getName().equals(name) ? idProperty.getFieldName() : name);
                Object obj = dbo.get(key);
                ctorParamNames.add(name);
                if (obj instanceof com.mongodb.DBRef) {
                    return (T)MappingMongoConverter.this.read(type, ((com.mongodb.DBRef)obj).fetch());
                }
                if (obj instanceof BasicDBList) {
                    BasicDBList objAsDbList = (BasicDBList)obj;
                    return (T)MappingMongoConverter.this.conversionService.convert((Object)MappingMongoConverter.this.readCollectionOrArray(type, objAsDbList), rawType);
                }
                if (obj instanceof DBObject) {
                    return (T)MappingMongoConverter.this.read(type, (DBObject)obj);
                }
                if (null != obj && obj.getClass().isAssignableFrom(rawType)) {
                    return (T)obj;
                }
                if (null != obj) {
                    return (T)MappingMongoConverter.this.conversionService.convert(obj, rawType);
                }
                return null;
            }
        };
        final BeanWrapper wrapper = BeanWrapper.create(entity, (ParameterValueProvider)provider, (ConversionService)this.conversionService);
        entity.doWithProperties((PropertyHandler)new PropertyHandler<MongoPersistentProperty>(){

            public void doWithPersistentProperty(MongoPersistentProperty prop) {
                boolean isConstructorProperty = ctorParamNames.contains(prop.getName());
                boolean hasValueForProperty = dbo.containsField(prop.getFieldName());
                if (!hasValueForProperty || isConstructorProperty) {
                    return;
                }
                Object obj = MappingMongoConverter.this.getValueInternal(prop, dbo, spelCtx, prop.getSpelExpression());
                try {
                    wrapper.setProperty((PersistentProperty)prop, obj, MappingMongoConverter.this.useFieldAccessOnly);
                }
                catch (IllegalAccessException e) {
                    throw new MappingException(e.getMessage(), (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    throw new MappingException(e.getMessage(), (Throwable)e);
                }
            }
        });
        entity.doWithAssociations((AssociationHandler)new AssociationHandler<MongoPersistentProperty>(){

            public void doWithAssociation(Association<MongoPersistentProperty> association) {
                MongoPersistentProperty inverseProp = (MongoPersistentProperty)association.getInverse();
                Object obj = MappingMongoConverter.this.getValueInternal(inverseProp, dbo, spelCtx, inverseProp.getSpelExpression());
                try {
                    wrapper.setProperty((PersistentProperty)inverseProp, obj);
                }
                catch (IllegalAccessException e) {
                    throw new MappingException(e.getMessage(), (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    throw new MappingException(e.getMessage(), (Throwable)e);
                }
            }
        });
        return (S)wrapper.getBean();
    }

    @Override
    public void write(Object obj, DBObject dbo) {
        boolean handledByCustomConverter;
        if (null == obj) {
            return;
        }
        boolean bl = handledByCustomConverter = this.conversions.getCustomWriteTarget(obj.getClass(), DBObject.class) != null;
        if (!handledByCustomConverter) {
            this.typeMapper.writeType(ClassTypeInformation.from(obj.getClass()), dbo);
        }
        this.writeInternal(obj, dbo);
    }

    protected void writeInternal(Object obj, DBObject dbo) {
        if (null == obj) {
            return;
        }
        Class<?> customTarget = this.conversions.getCustomWriteTarget(obj.getClass(), DBObject.class);
        if (customTarget != null) {
            DBObject result = (DBObject)this.conversionService.convert(obj, DBObject.class);
            dbo.putAll((BSONObject)result);
            return;
        }
        if (Map.class.isAssignableFrom(obj.getClass())) {
            this.writeMapInternal((Map)obj, dbo, null);
            return;
        }
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(obj.getClass());
        this.writeInternal(obj, dbo, entity);
    }

    protected void writeInternal(Object obj, final DBObject dbo, MongoPersistentEntity<?> entity) {
        if (obj == null) {
            return;
        }
        if (null == entity) {
            throw new MappingException("No mapping metadata found for entity of type " + obj.getClass().getName());
        }
        final BeanWrapper wrapper = BeanWrapper.create((Object)obj, (ConversionService)this.conversionService);
        final MongoPersistentProperty idProperty = (MongoPersistentProperty)entity.getIdProperty();
        if (!dbo.containsField("_id") && null != idProperty) {
            Class[] targetClasses;
            Object idObj = null;
            for (Class targetClass : targetClasses = new Class[]{ObjectId.class, String.class, Object.class}) {
                try {
                    idObj = wrapper.getProperty((PersistentProperty)idProperty, targetClass, this.useFieldAccessOnly);
                    if (null == idObj) continue;
                    break;
                }
                catch (ConversionException ignored) {
                }
                catch (IllegalAccessException e) {
                    throw new MappingException(e.getMessage(), (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    throw new MappingException(e.getMessage(), (Throwable)e);
                }
            }
            if (null != idObj) {
                dbo.put("_id", idObj);
            } else if (!VALID_ID_TYPES.contains(idProperty.getType())) {
                throw new MappingException("Invalid data type " + idProperty.getType().getName() + " for Id property. Should be one of " + VALID_ID_TYPES);
            }
        }
        entity.doWithProperties((PropertyHandler)new PropertyHandler<MongoPersistentProperty>(){

            public void doWithPersistentProperty(MongoPersistentProperty prop) {
                Object propertyObj;
                if (prop.equals(idProperty)) {
                    return;
                }
                try {
                    propertyObj = wrapper.getProperty((PersistentProperty)prop, prop.getType(), MappingMongoConverter.this.useFieldAccessOnly);
                }
                catch (IllegalAccessException e) {
                    throw new MappingException(e.getMessage(), (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    throw new MappingException(e.getMessage(), (Throwable)e);
                }
                if (null != propertyObj) {
                    if (!MappingMongoConverter.this.conversions.isSimpleType(propertyObj.getClass())) {
                        MappingMongoConverter.this.writePropertyInternal(propertyObj, dbo, prop);
                    } else {
                        MappingMongoConverter.this.writeSimpleInternal(propertyObj, dbo, prop.getFieldName());
                    }
                }
            }
        });
        entity.doWithAssociations((AssociationHandler)new AssociationHandler<MongoPersistentProperty>(){

            public void doWithAssociation(Association<MongoPersistentProperty> association) {
                Object propertyObj;
                MongoPersistentProperty inverseProp = (MongoPersistentProperty)association.getInverse();
                Class type = inverseProp.getType();
                try {
                    propertyObj = wrapper.getProperty((PersistentProperty)inverseProp, type, MappingMongoConverter.this.useFieldAccessOnly);
                }
                catch (IllegalAccessException e) {
                    throw new MappingException(e.getMessage(), (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    throw new MappingException(e.getMessage(), (Throwable)e);
                }
                if (null != propertyObj) {
                    MappingMongoConverter.this.writePropertyInternal(propertyObj, dbo, inverseProp);
                }
            }
        });
    }

    protected void writePropertyInternal(Object obj, DBObject dbo, MongoPersistentProperty prop) {
        com.mongodb.DBRef dbRefObj;
        if (obj == null) {
            return;
        }
        String name = prop.getFieldName();
        if (prop.isCollection()) {
            DBObject collectionInternal = this.createCollection(MappingMongoConverter.asCollection(obj), prop);
            dbo.put(name, (Object)collectionInternal);
            return;
        }
        TypeInformation type = prop.getTypeInformation();
        if (prop.isMap()) {
            BasicDBObject mapDbObj = new BasicDBObject();
            this.writeMapInternal((Map)obj, (DBObject)mapDbObj, type);
            dbo.put(name, (Object)mapDbObj);
            return;
        }
        if (prop.isDbReference() && null != (dbRefObj = this.createDBRef(obj, prop.getDBRef()))) {
            dbo.put(name, (Object)dbRefObj);
            return;
        }
        Class<?> basicTargetType = this.conversions.getCustomWriteTarget(obj.getClass(), null);
        if (basicTargetType != null) {
            dbo.put(name, this.conversionService.convert(obj, basicTargetType));
            return;
        }
        BasicDBObject propDbObj = new BasicDBObject();
        this.addCustomTypeKeyIfNecessary(type, obj, (DBObject)propDbObj);
        MongoPersistentEntity entity = this.isSubtype(prop.getType(), obj.getClass()) ? (MongoPersistentEntity)this.mappingContext.getPersistentEntity(obj.getClass()) : (MongoPersistentEntity)this.mappingContext.getPersistentEntity(type);
        this.writeInternal(obj, (DBObject)propDbObj, entity);
        dbo.put(name, (Object)propDbObj);
    }

    private boolean isSubtype(Class<?> left, Class<?> right) {
        return left.isAssignableFrom(right) && !left.equals(right);
    }

    private static Collection<?> asCollection(Object source) {
        if (source instanceof Collection) {
            return (Collection)source;
        }
        return source.getClass().isArray() ? CollectionUtils.arrayToList((Object)source) : Collections.singleton(source);
    }

    protected DBObject createCollection(Collection<?> collection, MongoPersistentProperty property) {
        if (!property.isDbReference()) {
            return this.createCollectionDBObject(collection, property.getTypeInformation());
        }
        BasicDBList dbList = new BasicDBList();
        for (Object element : collection) {
            if (element == null) continue;
            com.mongodb.DBRef dbRef = this.createDBRef(element, property.getDBRef());
            dbList.add((Object)dbRef);
        }
        return dbList;
    }

    private BasicDBList createCollectionDBObject(Collection<?> source, TypeInformation<?> type) {
        BasicDBList dbList = new BasicDBList();
        TypeInformation componentType = type == null ? null : type.getComponentType();
        for (Object element : source) {
            if (element == null) continue;
            Class<?> elementType = element.getClass();
            if (this.conversions.isSimpleType(elementType)) {
                dbList.add(this.getPotentiallyConvertedSimpleWrite(element));
                continue;
            }
            if (element instanceof Collection || elementType.isArray()) {
                dbList.add((Object)this.createCollectionDBObject(MappingMongoConverter.asCollection(element), componentType));
                continue;
            }
            BasicDBObject propDbObj = new BasicDBObject();
            this.writeInternal(element, (DBObject)propDbObj, (MongoPersistentEntity)this.mappingContext.getPersistentEntity(ClassTypeInformation.from(element.getClass())));
            this.addCustomTypeKeyIfNecessary(componentType, element, (DBObject)propDbObj);
            dbList.add((Object)propDbObj);
        }
        return dbList;
    }

    protected void writeMapInternal(Map<Object, Object> obj, DBObject dbo, TypeInformation<?> propertyType) {
        for (Map.Entry<Object, Object> entry : obj.entrySet()) {
            Object key = entry.getKey();
            Object val = entry.getValue();
            if (this.conversions.isSimpleType(key.getClass())) {
                String simpleKey = key.toString();
                if (val == null || this.conversions.isSimpleType(val.getClass())) {
                    this.writeSimpleInternal(val, dbo, simpleKey);
                    continue;
                }
                if (val instanceof Collection) {
                    dbo.put(simpleKey, (Object)this.createCollectionDBObject((Collection)val, propertyType.getMapValueType()));
                    continue;
                }
                BasicDBObject newDbo = new BasicDBObject();
                this.writeInternal(val, (DBObject)newDbo);
                this.addCustomTypeKeyIfNecessary(propertyType, val, (DBObject)newDbo);
                dbo.put(simpleKey, (Object)newDbo);
                continue;
            }
            throw new MappingException("Cannot use a complex object as a key value.");
        }
    }

    protected void addCustomTypeKeyIfNecessary(TypeInformation<?> type, Object value, DBObject dbObject) {
        boolean notTheSameClass;
        if (type == null) {
            return;
        }
        Class reference = type.getActualType().getType();
        boolean bl = notTheSameClass = !value.getClass().equals(reference);
        if (notTheSameClass) {
            this.typeMapper.writeType(value.getClass(), dbObject);
        }
    }

    private void writeSimpleInternal(Object value, DBObject dbObject, String key) {
        dbObject.put(key, this.getPotentiallyConvertedSimpleWrite(value));
    }

    private Object getPotentiallyConvertedSimpleWrite(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> customTarget = this.conversions.getCustomWriteTarget(value.getClass(), null);
        if (customTarget != null) {
            return this.conversionService.convert(value, customTarget);
        }
        return value.getClass().isEnum() ? ((Enum)value).name() : value;
    }

    private Object getPotentiallyConvertedSimpleRead(Object value, Class<?> target) {
        Assert.notNull(target);
        if (value == null) {
            return null;
        }
        if (this.conversions.hasCustomReadTarget(value.getClass(), target)) {
            return this.conversionService.convert(value, target);
        }
        if (target.isEnum()) {
            return Enum.valueOf(target, value.toString());
        }
        return value;
    }

    protected com.mongodb.DBRef createDBRef(Object target, DBRef dbref) {
        String dbname;
        MongoPersistentEntity targetEntity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(target.getClass());
        if (null == targetEntity || null == targetEntity.getIdProperty()) {
            return null;
        }
        MongoPersistentProperty idProperty = (MongoPersistentProperty)targetEntity.getIdProperty();
        Object id = null;
        BeanWrapper wrapper = BeanWrapper.create((Object)target, (ConversionService)this.conversionService);
        try {
            id = wrapper.getProperty((PersistentProperty)idProperty, Object.class, this.useFieldAccessOnly);
            if (null == id) {
                throw new MappingException("Cannot create a reference to an object with a NULL id.");
            }
        }
        catch (IllegalAccessException e) {
            throw new MappingException(e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new MappingException(e.getMessage(), (Throwable)e);
        }
        String collection = dbref.collection();
        if ("".equals(collection)) {
            collection = targetEntity.getCollection();
        }
        DB db = StringUtils.hasText((String)(dbname = dbref.db())) ? this.mongoDbFactory.getDb(dbname) : this.mongoDbFactory.getDb();
        return new com.mongodb.DBRef(db, collection, id);
    }

    protected Object getValueInternal(MongoPersistentProperty prop, DBObject dbo, StandardEvaluationContext ctx, String spelExpr) {
        Object o;
        if (null != spelExpr) {
            Expression x = this.spelExpressionParser.parseExpression(spelExpr);
            o = x.getValue((EvaluationContext)ctx);
        } else {
            Object sourceValue = dbo.get(prop.getFieldName());
            if (sourceValue == null) {
                return null;
            }
            Class propertyType = prop.getType();
            if (this.conversions.hasCustomReadTarget(sourceValue.getClass(), propertyType)) {
                return this.conversionService.convert(sourceValue, propertyType);
            }
            if (sourceValue instanceof com.mongodb.DBRef) {
                sourceValue = ((com.mongodb.DBRef)sourceValue).fetch();
            }
            if (sourceValue instanceof DBObject) {
                if (prop.isMap()) {
                    return this.readMap(prop.getTypeInformation(), (DBObject)sourceValue);
                }
                if (prop.isArray() && sourceValue instanceof BasicDBObject && ((DBObject)sourceValue).keySet().size() == 0) {
                    return Array.newInstance(prop.getComponentType(), 0);
                }
                if (prop.isCollection() && sourceValue instanceof BasicDBList) {
                    return this.readCollectionOrArray(prop.getTypeInformation(), (BasicDBList)sourceValue);
                }
                TypeInformation<?> toType = this.findTypeToBeUsed((DBObject)sourceValue);
                o = toType != null ? this.read(toType, (DBObject)sourceValue) : this.read((MongoPersistentEntity)this.mappingContext.getPersistentEntity(prop.getTypeInformation()), (DBObject)sourceValue);
            } else {
                o = sourceValue;
            }
        }
        return o;
    }

    private Collection<?> readCollectionOrArray(TypeInformation<?> targetType, BasicDBList sourceValue) {
        Assert.notNull(targetType);
        ArrayList<Object> items = targetType.getType().isArray() ? new ArrayList<Object>() : CollectionFactory.createCollection((Class)targetType.getType(), (int)sourceValue.size());
        for (int i = 0; i < sourceValue.size(); ++i) {
            Object dbObjItem = sourceValue.get(i);
            if (dbObjItem instanceof com.mongodb.DBRef) {
                items.add(this.read(targetType.getComponentType(), ((com.mongodb.DBRef)dbObjItem).fetch()));
                continue;
            }
            if (dbObjItem instanceof DBObject) {
                items.add(this.read(targetType.getComponentType(), (DBObject)dbObjItem));
                continue;
            }
            items.add(this.getPotentiallyConvertedSimpleRead(dbObjItem, targetType.getComponentType().getType()));
        }
        return items;
    }

    protected Map<Object, Object> readMap(TypeInformation<?> type, DBObject dbObject) {
        Assert.notNull((Object)dbObject);
        Class mapType = this.getMoreConcreteTargetType(dbObject, type).getType();
        Map map = CollectionFactory.createMap((Class)mapType, (int)dbObject.keySet().size());
        Map sourceMap = dbObject.toMap();
        for (Map.Entry entry : sourceMap.entrySet()) {
            if (this.typeMapper.isTypeKey((String)entry.getKey())) continue;
            Object key = entry.getKey();
            TypeInformation keyTypeInformation = type.getComponentType();
            if (keyTypeInformation != null) {
                Class keyType = keyTypeInformation.getType();
                key = this.conversionService.convert(entry.getKey(), keyType);
            }
            Object value = entry.getValue();
            TypeInformation valueType = type.getMapValueType();
            if (value instanceof DBObject) {
                map.put(key, this.read(valueType, (DBObject)value));
                continue;
            }
            valueType = valueType == null ? MAP_TYPE_INFORMATION : valueType;
            map.put(key, this.getPotentiallyConvertedSimpleRead(value, valueType.getType()));
        }
        return map;
    }

    protected TypeInformation<?> findTypeToBeUsed(DBObject dbObject) {
        return this.typeMapper.readType(dbObject);
    }

    private Class<?> getDefaultedTypeToBeUsed(DBObject dbObject) {
        TypeInformation<?> result = this.findTypeToBeUsed(dbObject);
        if (result != null) {
            return result.getType();
        }
        return dbObject instanceof BasicDBList ? List.class : Map.class;
    }

    private <S> TypeInformation<? extends S> getMoreConcreteTargetType(DBObject dbObject, TypeInformation<S> basicType) {
        Class rawType;
        Class<?> documentsTargetType = this.getDefaultedTypeToBeUsed(dbObject);
        Class clazz = rawType = basicType == null ? null : basicType.getType();
        boolean isMoreConcreteCustomType = rawType == null ? true : rawType.isAssignableFrom(documentsTargetType) && !rawType.equals(documentsTargetType);
        return isMoreConcreteCustomType ? ClassTypeInformation.from(documentsTargetType) : basicType;
    }

    protected <T> List<?> unwrapList(BasicDBList dbList, TypeInformation<T> targetType) {
        ArrayList<Object> rootList = new ArrayList<Object>();
        for (int i = 0; i < dbList.size(); ++i) {
            Object obj = dbList.get(i);
            if (obj instanceof BasicDBList) {
                rootList.add(this.unwrapList((BasicDBList)obj, targetType.getComponentType()));
                continue;
            }
            if (obj instanceof DBObject) {
                rootList.add(this.read(targetType, (DBObject)obj));
                continue;
            }
            rootList.add(obj);
        }
        return rootList;
    }

    @Override
    public Object convertToMongoType(Object obj) {
        if (obj == null) {
            return null;
        }
        Class<?> target = this.conversions.getCustomWriteTarget(this.getClass());
        if (target != null) {
            return this.conversionService.convert(obj, target);
        }
        if (null != obj && this.conversions.isSimpleType(obj.getClass())) {
            return this.getPotentiallyConvertedSimpleWrite(obj);
        }
        if (obj instanceof BasicDBList) {
            return this.maybeConvertList((BasicDBList)obj);
        }
        if (obj instanceof DBObject) {
            BasicDBObject newValueDbo = new BasicDBObject();
            for (String vk : ((DBObject)obj).keySet()) {
                Object o = ((DBObject)obj).get(vk);
                newValueDbo.put(vk, this.convertToMongoType(o));
            }
            return newValueDbo;
        }
        if (obj instanceof Map) {
            HashMap m = new HashMap();
            for (Map.Entry entry : ((Map)obj).entrySet()) {
                m.put(entry.getKey(), this.convertToMongoType(entry.getValue()));
            }
            return m;
        }
        if (obj instanceof List) {
            List l = (List)obj;
            ArrayList<Object> newList = new ArrayList<Object>();
            for (Object o : l) {
                newList.add(this.convertToMongoType(o));
            }
            return newList;
        }
        if (obj.getClass().isArray()) {
            return this.maybeConvertArray((Object[])obj);
        }
        BasicDBObject newDbo = new BasicDBObject();
        this.write(obj, (DBObject)newDbo);
        return newDbo;
    }

    public Object[] maybeConvertArray(Object[] src) {
        Object[] newArr = new Object[src.length];
        for (int i = 0; i < src.length; ++i) {
            newArr[i] = this.convertToMongoType(src[i]);
        }
        return newArr;
    }

    public BasicDBList maybeConvertList(BasicDBList dbl) {
        BasicDBList newDbl = new BasicDBList();
        for (Object o : dbl) {
            newDbl.add(this.convertToMongoType(o));
        }
        return newDbl;
    }
}

