/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.mapping;

import java.util.Comparator;
import org.springframework.data.mapping.model.BasicPersistentEntity;
import org.springframework.data.mongodb.MongoCollectionUtils;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicMongoPersistentEntity<T>
extends BasicPersistentEntity<T, MongoPersistentProperty>
implements MongoPersistentEntity<T> {
    private final String collection;

    public BasicMongoPersistentEntity(TypeInformation<T> typeInformation) {
        super(typeInformation, (Comparator)MongoPersistentPropertyComparator.INSTANCE);
        Document d;
        Class rawType = typeInformation.getType();
        String fallback = MongoCollectionUtils.getPreferredCollectionName(rawType);
        this.collection = rawType.isAnnotationPresent(Document.class) ? (StringUtils.hasText((String)(d = rawType.getAnnotation(Document.class)).collection()) ? d.collection() : fallback) : fallback;
    }

    @Override
    public String getCollection() {
        return this.collection;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum MongoPersistentPropertyComparator implements Comparator<MongoPersistentProperty>
    {
        INSTANCE;


        @Override
        public int compare(MongoPersistentProperty o1, MongoPersistentProperty o2) {
            if (o1.getFieldOrder() == Integer.MAX_VALUE) {
                return 1;
            }
            if (o2.getFieldOrder() == Integer.MAX_VALUE) {
                return -1;
            }
            return o1.getFieldOrder() - o2.getFieldOrder();
        }
    }
}

