/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.query;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.LinkedHashMap;
import org.bson.BSONObject;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Field;
import org.springframework.data.mongodb.core.query.NorCriteria;
import org.springframework.data.mongodb.core.query.OrCriteria;
import org.springframework.data.mongodb.core.query.Sort;

public class Query {
    private LinkedHashMap<String, CriteriaDefinition> criteria = new LinkedHashMap();
    private Field fieldSpec;
    private Sort sort;
    private int skip;
    private int limit;

    public static Query query(Criteria critera) {
        return new Query(critera);
    }

    public Query() {
    }

    public Query(Criteria criteria) {
        this.addCriteria(criteria);
    }

    public Query addCriteria(Criteria criteria) {
        this.criteria.put(criteria.getKey(), criteria);
        return this;
    }

    public Query or(Query ... queries) {
        this.criteria.put("$or", new OrCriteria(queries));
        return this;
    }

    public Query nor(Query ... queries) {
        this.criteria.put("$nor", new NorCriteria(queries));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Field fields() {
        Query query = this;
        synchronized (query) {
            if (this.fieldSpec == null) {
                this.fieldSpec = new Field();
            }
        }
        return this.fieldSpec;
    }

    public Query skip(int skip) {
        this.skip = skip;
        return this;
    }

    public Query limit(int limit) {
        this.limit = limit;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sort sort() {
        Query query = this;
        synchronized (query) {
            if (this.sort == null) {
                this.sort = new Sort();
            }
        }
        return this.sort;
    }

    public DBObject getQueryObject() {
        BasicDBObject dbo = new BasicDBObject();
        for (String k : this.criteria.keySet()) {
            CriteriaDefinition c = this.criteria.get(k);
            DBObject cl = c.getCriteriaObject();
            dbo.putAll((BSONObject)cl);
        }
        return dbo;
    }

    public DBObject getFieldsObject() {
        if (this.fieldSpec == null) {
            return null;
        }
        return this.fieldSpec.getFieldsObject();
    }

    public DBObject getSortObject() {
        if (this.sort == null) {
            return null;
        }
        return this.sort.getSortObject();
    }

    public int getSkip() {
        return this.skip;
    }

    public int getLimit() {
        return this.limit;
    }
}

