/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository;

import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.repository.AbstractMongoQuery;
import org.springframework.data.mongodb.repository.ConvertingParameterAccessor;
import org.springframework.data.mongodb.repository.MongoQueryCreator;
import org.springframework.data.mongodb.repository.MongoQueryMethod;
import org.springframework.data.repository.query.parser.PartTree;

public class PartTreeMongoQuery
extends AbstractMongoQuery {
    private final PartTree tree;
    private final boolean isGeoNearQuery;

    public PartTreeMongoQuery(MongoQueryMethod method, MongoTemplate template) {
        super(method, template);
        this.tree = new PartTree(method.getName(), method.getEntityInformation().getJavaType());
        this.isGeoNearQuery = method.isGeoNearQuery();
    }

    public PartTree getTree() {
        return this.tree;
    }

    protected Query createQuery(ConvertingParameterAccessor accessor) {
        MongoQueryCreator creator = new MongoQueryCreator(this.tree, accessor, this.isGeoNearQuery);
        return (Query)creator.createQuery();
    }
}

