/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository;

import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mysema.query.mongodb.MongodbQuery;
import com.mysema.query.mongodb.MongodbSerializer;
import com.mysema.query.types.EntityPath;
import org.apache.commons.collections15.Transformer;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QuerydslRepositorySupport {
    private final MongoOperations template;
    private final MappingContext<? extends MongoPersistentEntity<?>, ?> context;
    private final MongodbSerializer serializer;

    public QuerydslRepositorySupport(MongoOperations operations) {
        Assert.notNull((Object)operations);
        this.template = operations;
        this.context = operations.getConverter().getMappingContext();
        this.serializer = new MongodbSerializer();
    }

    protected <T> MongodbQuery<T> from(EntityPath<T> path) {
        Assert.notNull(path);
        MongoPersistentEntity entity = (MongoPersistentEntity)this.context.getPersistentEntity(path.getType());
        return this.from(path, entity.getCollection());
    }

    protected <T> MongodbQuery<T> from(final EntityPath<T> path, String collection) {
        Assert.notNull(path);
        Assert.hasText((String)collection);
        DBCollection dbCollection = this.template.getCollection(collection);
        return new MongodbQuery(dbCollection, new Transformer<DBObject, T>(){

            public T transform(DBObject input) {
                return QuerydslRepositorySupport.this.template.getConverter().read(path.getType(), input);
            }
        }, this.serializer);
    }
}

