/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.index;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.util.Assert;

public class GeospatialIndex
implements IndexDefinition {
    private final String field;
    private String name;
    private Integer min = null;
    private Integer max = null;
    private Integer bits = null;

    public GeospatialIndex(String field) {
        Assert.hasText((String)field);
        this.field = field;
    }

    public GeospatialIndex named(String name) {
        this.name = name;
        return this;
    }

    public GeospatialIndex withMin(int min) {
        this.min = min;
        return this;
    }

    public GeospatialIndex withMax(int max) {
        this.max = max;
        return this;
    }

    public GeospatialIndex withBits(int bits) {
        this.bits = bits;
        return this;
    }

    public DBObject getIndexKeys() {
        BasicDBObject dbo = new BasicDBObject();
        dbo.put(this.field, (Object)"2d");
        return dbo;
    }

    public DBObject getIndexOptions() {
        if (this.name == null && this.min == null && this.max == null) {
            return null;
        }
        BasicDBObject dbo = new BasicDBObject();
        if (this.name != null) {
            dbo.put("name", (Object)this.name);
        }
        if (this.min != null) {
            dbo.put("min", (Object)this.min);
        }
        if (this.max != null) {
            dbo.put("max", (Object)this.max);
        }
        if (this.bits != null) {
            dbo.put("bits", (Object)this.bits);
        }
        return dbo;
    }

    public String toString() {
        return String.format("Geo index: %s - Options: %s", this.getIndexKeys(), this.getIndexOptions());
    }
}

