/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.config;

import com.mongodb.MongoURI;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.authentication.UserCredentials;
import org.springframework.data.mongodb.config.ParsingUtils;
import org.springframework.data.mongodb.core.MongoFactoryBean;
import org.springframework.data.mongodb.core.SimpleMongoDbFactory;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class MongoDbFactoryParser
extends AbstractBeanDefinitionParser {
    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        String id = element.getAttribute("id");
        if (!StringUtils.hasText((String)id)) {
            id = "mongoDbFactory";
        }
        return id;
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        String uri = element.getAttribute("uri");
        String mongoRef = element.getAttribute("mongo-ref");
        String dbname = element.getAttribute("dbname");
        BeanDefinition userCredentials = this.getUserCredentialsBeanDefinition(element, parserContext);
        BeanDefinitionBuilder dbFactoryBuilder = BeanDefinitionBuilder.genericBeanDefinition(SimpleMongoDbFactory.class);
        ParsingUtils.setPropertyValue(element, dbFactoryBuilder, "write-concern", "writeConcern");
        if (StringUtils.hasText((String)uri)) {
            if (StringUtils.hasText((String)mongoRef) || StringUtils.hasText((String)dbname) || userCredentials != null) {
                parserContext.getReaderContext().error("Configure either Mongo URI or details individually!", parserContext.extractSource((Object)element));
            }
            dbFactoryBuilder.addConstructorArgValue((Object)this.getMongoUri(uri));
            return ParsingUtils.getSourceBeanDefinition(dbFactoryBuilder, parserContext, element);
        }
        mongoRef = StringUtils.hasText((String)mongoRef) ? mongoRef : this.registerMongoBeanDefinition(element, parserContext);
        dbname = StringUtils.hasText((String)dbname) ? dbname : "db";
        dbFactoryBuilder.addConstructorArgValue((Object)new RuntimeBeanReference(mongoRef));
        dbFactoryBuilder.addConstructorArgValue((Object)dbname);
        if (userCredentials != null) {
            dbFactoryBuilder.addConstructorArgValue((Object)userCredentials);
        }
        ParsingUtils.registerWriteConcernPropertyEditor(parserContext.getRegistry());
        return ParsingUtils.getSourceBeanDefinition(dbFactoryBuilder, parserContext, element);
    }

    private String registerMongoBeanDefinition(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder mongoBuilder = BeanDefinitionBuilder.genericBeanDefinition(MongoFactoryBean.class);
        ParsingUtils.setPropertyValue(element, mongoBuilder, "host");
        ParsingUtils.setPropertyValue(element, mongoBuilder, "port");
        return BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)mongoBuilder.getBeanDefinition(), (BeanDefinitionRegistry)parserContext.getRegistry());
    }

    private BeanDefinition getUserCredentialsBeanDefinition(Element element, ParserContext context) {
        String username = element.getAttribute("username");
        String password = element.getAttribute("password");
        if (!StringUtils.hasText((String)username) && !StringUtils.hasText((String)password)) {
            return null;
        }
        BeanDefinitionBuilder userCredentialsBuilder = BeanDefinitionBuilder.genericBeanDefinition(UserCredentials.class);
        userCredentialsBuilder.addConstructorArgValue((Object)(StringUtils.hasText((String)username) ? username : null));
        userCredentialsBuilder.addConstructorArgValue((Object)(StringUtils.hasText((String)password) ? password : null));
        return ParsingUtils.getSourceBeanDefinition(userCredentialsBuilder, context, element);
    }

    private BeanDefinition getMongoUri(String uri) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(MongoURI.class);
        builder.addConstructorArgValue((Object)uri);
        return builder.getBeanDefinition();
    }
}

