/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.ExposedFields;
import org.springframework.data.mongodb.core.aggregation.ExposedFieldsAggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.data.mongodb.core.aggregation.FieldsExposingAggregationOperation;
import org.springframework.data.mongodb.core.aggregation.GroupOperation;
import org.springframework.data.mongodb.core.aggregation.LimitOperation;
import org.springframework.data.mongodb.core.aggregation.MatchOperation;
import org.springframework.data.mongodb.core.aggregation.ProjectionOperation;
import org.springframework.data.mongodb.core.aggregation.SkipOperation;
import org.springframework.data.mongodb.core.aggregation.SortOperation;
import org.springframework.data.mongodb.core.aggregation.TypedAggregation;
import org.springframework.data.mongodb.core.aggregation.UnwindOperation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.SerializationUtils;
import org.springframework.util.Assert;

public class Aggregation {
    public static final AggregationOperationContext DEFAULT_CONTEXT = new NoOpAggregationOperationContext();
    private final List<AggregationOperation> operations;

    public static Aggregation newAggregation(AggregationOperation ... operations) {
        return new Aggregation(operations);
    }

    public static <T> TypedAggregation<T> newAggregation(Class<T> type, AggregationOperation ... operations) {
        return new TypedAggregation<T>(type, operations);
    }

    protected Aggregation(AggregationOperation ... aggregationOperations) {
        Assert.notNull((Object)aggregationOperations, (String)"AggregationOperations must not be null!");
        Assert.isTrue((aggregationOperations.length > 0 ? 1 : 0) != 0, (String)"At least one AggregationOperation has to be provided");
        this.operations = Arrays.asList(aggregationOperations);
    }

    public static String previousOperation() {
        return "_id";
    }

    public static ProjectionOperation project(String ... fields) {
        return Aggregation.project(Aggregation.fields(fields));
    }

    public static ProjectionOperation project(Fields fields) {
        return new ProjectionOperation(fields);
    }

    public static UnwindOperation unwind(String field) {
        return new UnwindOperation(Fields.field(field));
    }

    public static GroupOperation group(String ... fields) {
        return Aggregation.group(Aggregation.fields(fields));
    }

    public static GroupOperation group(Fields fields) {
        return new GroupOperation(fields);
    }

    public static SortOperation sort(Sort sort) {
        return new SortOperation(sort);
    }

    public static SortOperation sort(Sort.Direction direction, String ... fields) {
        return new SortOperation(new Sort(direction, fields));
    }

    public static SkipOperation skip(int elementsToSkip) {
        return new SkipOperation(elementsToSkip);
    }

    public static LimitOperation limit(long maxElements) {
        return new LimitOperation(maxElements);
    }

    public static MatchOperation match(Criteria criteria) {
        return new MatchOperation(criteria);
    }

    public static Fields fields(String ... fields) {
        return Fields.fields(fields);
    }

    public static Fields bind(String name, String target) {
        return Fields.from(Fields.field(name, target));
    }

    public DBObject toDbObject(String inputCollectionName, AggregationOperationContext rootContext) {
        AggregationOperationContext context = rootContext;
        ArrayList<DBObject> operationDocuments = new ArrayList<DBObject>(this.operations.size());
        for (AggregationOperation operation : this.operations) {
            operationDocuments.add(operation.toDBObject(context));
            if (!(operation instanceof FieldsExposingAggregationOperation)) continue;
            FieldsExposingAggregationOperation exposedFieldsOperation = (FieldsExposingAggregationOperation)operation;
            context = new ExposedFieldsAggregationOperationContext(exposedFieldsOperation.getFields());
        }
        BasicDBObject command = new BasicDBObject("aggregate", (Object)inputCollectionName);
        command.put("pipeline", operationDocuments);
        return command;
    }

    public String toString() {
        return SerializationUtils.serializeToJsonSafely(this.toDbObject("__collection__", new NoOpAggregationOperationContext()));
    }

    private static class NoOpAggregationOperationContext
    implements AggregationOperationContext {
        private NoOpAggregationOperationContext() {
        }

        @Override
        public DBObject getMappedObject(DBObject dbObject) {
            return dbObject;
        }

        @Override
        public ExposedFields.FieldReference getReference(Field field) {
            return new ExposedFields.FieldReference(new ExposedFields.ExposedField(field, true));
        }

        @Override
        public ExposedFields.FieldReference getReference(String name) {
            return new ExposedFields.FieldReference(new ExposedFields.ExposedField(new Fields.AggregationField(name), true));
        }
    }
}

