/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.mapping;

import java.util.ArrayList;
import java.util.List;
import org.springframework.data.mongodb.core.mapping.FieldNamingStrategy;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.util.ParsingUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class CamelCaseSplittingFieldNamingStrategy
implements FieldNamingStrategy {
    private final String delimiter;

    public CamelCaseSplittingFieldNamingStrategy(String delimiter) {
        Assert.notNull((Object)delimiter, (String)"Delimiter must not be null!");
        this.delimiter = delimiter;
    }

    @Override
    public String getFieldName(MongoPersistentProperty property) {
        List parts = ParsingUtils.splitCamelCaseToLower((String)property.getName());
        ArrayList<String> result = new ArrayList<String>();
        for (String part : parts) {
            String candidate = this.preparePart(part);
            if (!StringUtils.hasText((String)candidate)) continue;
            result.add(candidate);
        }
        return StringUtils.collectionToDelimitedString(result, (String)this.delimiter);
    }

    protected String preparePart(String part) {
        return part;
    }
}

