/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.gridfs;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBObject;
import com.mongodb.gridfs.GridFS;
import com.mongodb.gridfs.GridFSDBFile;
import com.mongodb.gridfs.GridFSFile;
import com.mongodb.gridfs.GridFSInputFile;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.convert.QueryMapper;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.gridfs.AntPath;
import org.springframework.data.mongodb.gridfs.GridFsCriteria;
import org.springframework.data.mongodb.gridfs.GridFsOperations;
import org.springframework.data.mongodb.gridfs.GridFsResource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class GridFsTemplate
implements GridFsOperations,
ResourcePatternResolver {
    private final MongoDbFactory dbFactory;
    private final String bucket;
    private final MongoConverter converter;
    private final QueryMapper queryMapper;

    public GridFsTemplate(MongoDbFactory dbFactory, MongoConverter converter) {
        this(dbFactory, converter, null);
    }

    public GridFsTemplate(MongoDbFactory dbFactory, MongoConverter converter, String bucket) {
        Assert.notNull((Object)dbFactory);
        Assert.notNull((Object)converter);
        this.dbFactory = dbFactory;
        this.converter = converter;
        this.bucket = bucket;
        this.queryMapper = new QueryMapper(converter);
    }

    @Override
    public GridFSFile store(InputStream content, String filename) {
        return this.store(content, filename, (Object)null);
    }

    @Override
    public GridFSFile store(InputStream content, Object metadata) {
        return this.store(content, null, metadata);
    }

    @Override
    public GridFSFile store(InputStream content, DBObject metadata) {
        return this.store(content, (String)null, metadata);
    }

    @Override
    public GridFSFile store(InputStream content, String filename, String contentType) {
        return this.store(content, filename, contentType, (Object)null);
    }

    @Override
    public GridFSFile store(InputStream content, String filename, Object metadata) {
        return this.store(content, filename, null, metadata);
    }

    @Override
    public GridFSFile store(InputStream content, String filename, String contentType, Object metadata) {
        BasicDBObject dbObject = null;
        if (metadata != null) {
            dbObject = new BasicDBObject();
            this.converter.write(metadata, dbObject);
        }
        return this.store(content, filename, contentType, (DBObject)dbObject);
    }

    @Override
    public GridFSFile store(InputStream content, String filename, DBObject metadata) {
        return this.store(content, filename, (String)null, metadata);
    }

    @Override
    public GridFSFile store(InputStream content, String filename, String contentType, DBObject metadata) {
        Assert.notNull((Object)content);
        GridFSInputFile file = this.getGridFs().createFile(content);
        if (filename != null) {
            file.setFilename(filename);
        }
        if (metadata != null) {
            file.setMetaData(metadata);
        }
        if (contentType != null) {
            file.setContentType(contentType);
        }
        file.save();
        return file;
    }

    @Override
    public List<GridFSDBFile> find(Query query) {
        if (query == null) {
            return this.getGridFs().find((DBObject)null);
        }
        DBObject queryObject = this.getMappedQuery(query.getQueryObject());
        DBObject sortObject = this.getMappedQuery(query.getSortObject());
        return this.getGridFs().find(queryObject, sortObject);
    }

    @Override
    public GridFSDBFile findOne(Query query) {
        return this.getGridFs().findOne(this.getMappedQuery(query));
    }

    @Override
    public void delete(Query query) {
        this.getGridFs().remove(this.getMappedQuery(query));
    }

    public ClassLoader getClassLoader() {
        return this.dbFactory.getClass().getClassLoader();
    }

    @Override
    public GridFsResource getResource(String location) {
        GridFSDBFile file = this.findOne(Query.query(GridFsCriteria.whereFilename().is(location)));
        return file != null ? new GridFsResource(file) : null;
    }

    @Override
    public GridFsResource[] getResources(String locationPattern) {
        if (!StringUtils.hasText((String)locationPattern)) {
            return new GridFsResource[0];
        }
        AntPath path = new AntPath(locationPattern);
        if (path.isPattern()) {
            List<GridFSDBFile> files = this.find(Query.query(GridFsCriteria.whereFilename().regex(path.toRegex())));
            ArrayList<GridFsResource> resources = new ArrayList<GridFsResource>(files.size());
            for (GridFSDBFile file : files) {
                resources.add(new GridFsResource(file));
            }
            return resources.toArray(new GridFsResource[resources.size()]);
        }
        return new GridFsResource[]{this.getResource(locationPattern)};
    }

    private DBObject getMappedQuery(Query query) {
        return query == null ? new Query().getQueryObject() : this.getMappedQuery(query.getQueryObject());
    }

    private DBObject getMappedQuery(DBObject query) {
        return query == null ? null : this.queryMapper.getMappedObject(query, null);
    }

    private GridFS getGridFs() {
        DB db = this.dbFactory.getDb();
        return this.bucket == null ? new GridFS(db) : new GridFS(db, this.bucket);
    }
}

