/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.config;

import com.mongodb.Mongo;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.annotation.Persistent;
import org.springframework.data.authentication.UserCredentials;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.context.MappingContextIsNewStrategyFactory;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoDbFactory;
import org.springframework.data.mongodb.core.convert.CustomConversions;
import org.springframework.data.mongodb.core.convert.DefaultDbRefResolver;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.mapping.CamelCaseAbbreviatingFieldNamingStrategy;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.FieldNamingStrategy;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.mapping.PropertyNameFieldNamingStrategy;
import org.springframework.data.support.CachingIsNewStrategyFactory;
import org.springframework.data.support.IsNewStrategyFactory;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@Configuration
public abstract class AbstractMongoConfiguration {
    protected abstract String getDatabaseName();

    protected String getAuthenticationDatabaseName() {
        return null;
    }

    public abstract Mongo mongo() throws Exception;

    @Bean
    public MongoTemplate mongoTemplate() throws Exception {
        return new MongoTemplate(this.mongoDbFactory(), this.mappingMongoConverter());
    }

    @Bean
    public MongoDbFactory mongoDbFactory() throws Exception {
        return new SimpleMongoDbFactory(this.mongo(), this.getDatabaseName(), this.getUserCredentials(), this.getAuthenticationDatabaseName());
    }

    protected String getMappingBasePackage() {
        Package mappingBasePackage = this.getClass().getPackage();
        return mappingBasePackage == null ? null : mappingBasePackage.getName();
    }

    protected UserCredentials getUserCredentials() {
        return null;
    }

    @Bean
    public MongoMappingContext mongoMappingContext() throws ClassNotFoundException {
        MongoMappingContext mappingContext = new MongoMappingContext();
        mappingContext.setInitialEntitySet(this.getInitialEntitySet());
        mappingContext.setSimpleTypeHolder(this.customConversions().getSimpleTypeHolder());
        mappingContext.setFieldNamingStrategy(this.fieldNamingStrategy());
        return mappingContext;
    }

    @Bean
    public IsNewStrategyFactory isNewStrategyFactory() throws ClassNotFoundException {
        return new CachingIsNewStrategyFactory((IsNewStrategyFactory)new MappingContextIsNewStrategyFactory((MappingContext)this.mongoMappingContext()));
    }

    @Bean
    public CustomConversions customConversions() {
        return new CustomConversions(Collections.emptyList());
    }

    @Bean
    public MappingMongoConverter mappingMongoConverter() throws Exception {
        DefaultDbRefResolver dbRefResolver = new DefaultDbRefResolver(this.mongoDbFactory());
        MappingMongoConverter converter = new MappingMongoConverter(dbRefResolver, (MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty>)this.mongoMappingContext());
        converter.setCustomConversions(this.customConversions());
        return converter;
    }

    protected Set<Class<?>> getInitialEntitySet() throws ClassNotFoundException {
        String basePackage = this.getMappingBasePackage();
        HashSet initialEntitySet = new HashSet();
        if (StringUtils.hasText((String)basePackage)) {
            ClassPathScanningCandidateComponentProvider componentProvider = new ClassPathScanningCandidateComponentProvider(false);
            componentProvider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Document.class));
            componentProvider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Persistent.class));
            for (BeanDefinition candidate : componentProvider.findCandidateComponents(basePackage)) {
                initialEntitySet.add(ClassUtils.forName((String)candidate.getBeanClassName(), (ClassLoader)AbstractMongoConfiguration.class.getClassLoader()));
            }
        }
        return initialEntitySet;
    }

    protected boolean abbreviateFieldNames() {
        return false;
    }

    protected FieldNamingStrategy fieldNamingStrategy() {
        return this.abbreviateFieldNames() ? new CamelCaseAbbreviatingFieldNamingStrategy() : PropertyNameFieldNamingStrategy.INSTANCE;
    }
}

