/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bson.BSONObject;
import org.bson.types.ObjectId;
import org.springframework.core.convert.ConversionException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.mapping.PropertyReferenceException;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.context.PersistentPropertyPath;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

public class QueryMapper {
    private static final List<String> DEFAULT_ID_NAMES = Arrays.asList("id", "_id");
    private static final DBObject META_TEXT_SCORE = new BasicDBObject("$meta", (Object)"textScore");
    private final ConversionService conversionService;
    private final MongoConverter converter;
    private final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;

    public QueryMapper(MongoConverter converter) {
        Assert.notNull((Object)converter);
        this.conversionService = converter.getConversionService();
        this.converter = converter;
        this.mappingContext = converter.getMappingContext();
    }

    public DBObject getMappedObject(DBObject query, MongoPersistentEntity<?> entity) {
        if (this.isNestedKeyword(query)) {
            return this.getMappedKeyword(new Keyword(query), entity);
        }
        BasicDBObject result = new BasicDBObject();
        for (String key : query.keySet()) {
            if (Query.isRestrictedTypeKey(key)) {
                Set restrictedTypes = (Set)query.get(key);
                this.converter.getTypeMapper().writeTypeRestrictions((DBObject)result, restrictedTypes);
                continue;
            }
            if (this.isKeyword(key)) {
                result.putAll((BSONObject)this.getMappedKeyword(new Keyword(query, key), entity));
                continue;
            }
            Field field = this.createPropertyField(entity, key, this.mappingContext);
            Map.Entry<String, Object> entry = this.getMappedObjectForField(field, query.get(key));
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public DBObject getMappedSort(DBObject sortObject, MongoPersistentEntity<?> entity) {
        if (sortObject == null) {
            return null;
        }
        DBObject mappedSort = this.getMappedObject(sortObject, entity);
        this.mapMetaAttributes(mappedSort, entity, MetaMapping.WHEN_PRESENT);
        return mappedSort;
    }

    public DBObject getMappedFields(DBObject fieldsObject, MongoPersistentEntity<?> entity) {
        BasicDBObject mappedFields = fieldsObject != null ? this.getMappedObject(fieldsObject, entity) : new BasicDBObject();
        this.mapMetaAttributes((DBObject)mappedFields, entity, MetaMapping.FORCE);
        return mappedFields.keySet().isEmpty() ? null : mappedFields;
    }

    private void mapMetaAttributes(DBObject source, MongoPersistentEntity<?> entity, MetaMapping metaMapping) {
        if (entity == null || source == null) {
            return;
        }
        if (entity.hasTextScoreProperty() && !MetaMapping.IGNORE.equals((Object)metaMapping)) {
            MongoPersistentProperty textScoreProperty = entity.getTextScoreProperty();
            if (MetaMapping.FORCE.equals((Object)metaMapping) || MetaMapping.WHEN_PRESENT.equals((Object)metaMapping) && source.containsField(textScoreProperty.getFieldName())) {
                source.putAll((BSONObject)this.getMappedTextScoreField(textScoreProperty));
            }
        }
    }

    private DBObject getMappedTextScoreField(MongoPersistentProperty property) {
        return new BasicDBObject(property.getFieldName(), (Object)META_TEXT_SCORE);
    }

    protected Map.Entry<String, Object> getMappedObjectForField(Field field, Object rawValue) {
        Object value;
        String key = field.getMappedKey();
        if (this.isNestedKeyword(rawValue) && !field.isIdField()) {
            Keyword keyword = new Keyword((DBObject)rawValue);
            value = this.getMappedKeyword(field, keyword);
        } else {
            value = this.getMappedValue(field, rawValue);
        }
        return this.createMapEntry(key, value);
    }

    protected Field createPropertyField(MongoPersistentEntity<?> entity, String key, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext) {
        return entity == null ? new Field(key) : new MetadataBackedField(key, entity, mappingContext);
    }

    protected DBObject getMappedKeyword(Keyword keyword, MongoPersistentEntity<?> entity) {
        if (keyword.isOrOrNor() || keyword.hasIterableValue()) {
            Iterable conditions = (Iterable)keyword.getValue();
            BasicDBList newConditions = new BasicDBList();
            for (Object condition : conditions) {
                newConditions.add(this.isDBObject(condition) ? this.getMappedObject((DBObject)condition, entity) : this.convertSimpleOrDBObject(condition, entity));
            }
            return new BasicDBObject(keyword.getKey(), (Object)newConditions);
        }
        return new BasicDBObject(keyword.getKey(), this.convertSimpleOrDBObject(keyword.getValue(), entity));
    }

    protected DBObject getMappedKeyword(Field property, Keyword keyword) {
        boolean needsAssociationConversion = property.isAssociation() && !keyword.isExists();
        Object value = keyword.getValue();
        Object convertedValue = needsAssociationConversion ? this.convertAssociation(value, property) : this.getMappedValue(property.with(keyword.getKey()), value);
        return new BasicDBObject(keyword.key, convertedValue);
    }

    protected Object getMappedValue(Field documentField, Object value) {
        if (documentField.isIdField()) {
            if (this.isDBObject(value)) {
                DBObject valueDbo = (DBObject)value;
                BasicDBObject resultDbo = new BasicDBObject(valueDbo.toMap());
                if (valueDbo.containsField("$in") || valueDbo.containsField("$nin")) {
                    String inKey = valueDbo.containsField("$in") ? "$in" : "$nin";
                    ArrayList<Object> ids = new ArrayList<Object>();
                    for (Object id : (Iterable)valueDbo.get(inKey)) {
                        ids.add(this.convertId(id));
                    }
                    resultDbo.put(inKey, (Object)ids.toArray(new Object[ids.size()]));
                } else if (valueDbo.containsField("$ne")) {
                    resultDbo.put("$ne", this.convertId(valueDbo.get("$ne")));
                } else {
                    return this.getMappedObject((DBObject)resultDbo, null);
                }
                return resultDbo;
            }
            return this.convertId(value);
        }
        if (this.isNestedKeyword(value)) {
            return this.getMappedKeyword(new Keyword((DBObject)value), null);
        }
        if (this.isAssociationConversionNecessary(documentField, value)) {
            return this.convertAssociation(value, documentField);
        }
        return this.convertSimpleOrDBObject(value, documentField.getPropertyEntity());
    }

    protected boolean isAssociationConversionNecessary(Field documentField, Object value) {
        Assert.notNull((Object)documentField, (String)"Document field must not be null!");
        if (value == null) {
            return false;
        }
        if (!documentField.isAssociation()) {
            return false;
        }
        Class<?> type = value.getClass();
        MongoPersistentProperty property = documentField.getProperty();
        if (property.getActualType().isAssignableFrom(type)) {
            return true;
        }
        MongoPersistentEntity<?> entity = documentField.getPropertyEntity();
        return entity.hasIdProperty() && (type.equals(DBRef.class) || ((MongoPersistentProperty)entity.getIdProperty()).getActualType().isAssignableFrom(type));
    }

    protected Object convertSimpleOrDBObject(Object source, MongoPersistentEntity<?> entity) {
        if (source instanceof BasicDBList) {
            return this.delegateConvertToMongoType(source, entity);
        }
        if (this.isDBObject(source)) {
            return this.getMappedObject((DBObject)source, entity);
        }
        return this.delegateConvertToMongoType(source, entity);
    }

    protected Object delegateConvertToMongoType(Object source, MongoPersistentEntity<?> entity) {
        return this.converter.convertToMongoType(source, entity == null ? null : entity.getTypeInformation());
    }

    protected Object convertAssociation(Object source, Field field) {
        return this.convertAssociation(source, field.getProperty());
    }

    protected Object convertAssociation(Object source, MongoPersistentProperty property) {
        if (property == null || source == null || source instanceof DBObject) {
            return source;
        }
        if (source instanceof DBRef) {
            DBRef ref = (DBRef)source;
            return new DBRef(ref.getDB(), ref.getRef(), this.convertId(ref.getId()));
        }
        if (source instanceof Iterable) {
            BasicDBList result = new BasicDBList();
            for (Object element : (Iterable)source) {
                result.add((Object)this.createDbRefFor(element, property));
            }
            return result;
        }
        if (property.isMap()) {
            BasicDBObject result = new BasicDBObject();
            DBObject dbObject = (DBObject)source;
            for (String key : dbObject.keySet()) {
                result.put(key, (Object)this.createDbRefFor(dbObject.get(key), property));
            }
            return result;
        }
        return this.createDbRefFor(source, property);
    }

    protected final boolean isDBObject(Object value) {
        return value instanceof DBObject;
    }

    protected final Map.Entry<String, Object> createMapEntry(Field field, Object value) {
        return this.createMapEntry(field.getMappedKey(), value);
    }

    private Map.Entry<String, Object> createMapEntry(String key, Object value) {
        Assert.hasText((String)key, (String)"Key must not be null or empty!");
        return Collections.singletonMap(key, value).entrySet().iterator().next();
    }

    private DBRef createDbRefFor(Object source, MongoPersistentProperty property) {
        if (source instanceof DBRef) {
            return (DBRef)source;
        }
        return this.converter.toDBRef(source, property);
    }

    public Object convertId(Object id) {
        if (id == null) {
            return null;
        }
        if (id instanceof String) {
            return ObjectId.isValid((String)id.toString()) ? this.conversionService.convert(id, ObjectId.class) : id;
        }
        try {
            return this.conversionService.canConvert(id.getClass(), ObjectId.class) ? this.conversionService.convert(id, ObjectId.class) : this.delegateConvertToMongoType(id, null);
        }
        catch (ConversionException o_O) {
            return this.delegateConvertToMongoType(id, null);
        }
    }

    protected boolean isNestedKeyword(Object candidate) {
        if (!(candidate instanceof BasicDBObject)) {
            return false;
        }
        BasicDBObject dbObject = (BasicDBObject)candidate;
        Set keys = dbObject.keySet();
        if (keys.size() != 1) {
            return false;
        }
        return this.isKeyword(((String)keys.iterator().next()).toString());
    }

    protected boolean isKeyword(String candidate) {
        return candidate.startsWith("$");
    }

    protected static class AssociationConverter
    implements Converter<MongoPersistentProperty, String> {
        private final MongoPersistentProperty property;
        private boolean associationFound;

        public AssociationConverter(Association<MongoPersistentProperty> association) {
            Assert.notNull(association, (String)"Association must not be null!");
            this.property = (MongoPersistentProperty)association.getInverse();
        }

        public String convert(MongoPersistentProperty source) {
            if (this.associationFound) {
                return null;
            }
            if (this.property.equals(source)) {
                this.associationFound = true;
            }
            return source.getFieldName();
        }
    }

    protected static class MetadataBackedField
    extends Field {
        private static final String INVALID_ASSOCIATION_REFERENCE = "Invalid path reference %s! Associations can only be pointed to directly or via their id property!";
        private final MongoPersistentEntity<?> entity;
        private final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;
        private final MongoPersistentProperty property;
        private final PersistentPropertyPath<MongoPersistentProperty> path;
        private final Association<MongoPersistentProperty> association;

        public MetadataBackedField(String name, MongoPersistentEntity<?> entity, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> context) {
            this(name, entity, context, null);
        }

        public MetadataBackedField(String name, MongoPersistentEntity<?> entity, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> context, MongoPersistentProperty property) {
            super(name);
            Assert.notNull(entity, (String)"MongoPersistentEntity must not be null!");
            this.entity = entity;
            this.mappingContext = context;
            this.path = this.getPath(name);
            this.property = this.path == null ? property : (MongoPersistentProperty)this.path.getLeafProperty();
            this.association = this.findAssociation();
        }

        @Override
        public MetadataBackedField with(String name) {
            return new MetadataBackedField(name, this.entity, this.mappingContext, this.property);
        }

        @Override
        public boolean isIdField() {
            MongoPersistentProperty idProperty = (MongoPersistentProperty)this.entity.getIdProperty();
            if (idProperty != null) {
                return idProperty.getName().equals(this.name) || idProperty.getFieldName().equals(this.name);
            }
            return DEFAULT_ID_NAMES.contains(this.name);
        }

        @Override
        public MongoPersistentProperty getProperty() {
            return this.association == null ? this.property : (MongoPersistentProperty)this.association.getInverse();
        }

        @Override
        public MongoPersistentEntity<?> getPropertyEntity() {
            MongoPersistentProperty property = this.getProperty();
            return property == null ? null : (MongoPersistentEntity)this.mappingContext.getPersistentEntity((PersistentProperty)property);
        }

        @Override
        public boolean isAssociation() {
            return this.association != null;
        }

        @Override
        public Association<MongoPersistentProperty> getAssociation() {
            return this.association;
        }

        private final Association<MongoPersistentProperty> findAssociation() {
            if (this.path != null) {
                for (MongoPersistentProperty p : this.path) {
                    if (!p.isAssociation()) continue;
                    return p.getAssociation();
                }
            }
            return null;
        }

        @Override
        public String getMappedKey() {
            return this.path == null ? this.name : this.path.toDotPath(this.isAssociation() ? this.getAssociationConverter() : this.getPropertyConverter());
        }

        protected PersistentPropertyPath<MongoPersistentProperty> getPath() {
            return this.path;
        }

        private PersistentPropertyPath<MongoPersistentProperty> getPath(String pathExpression) {
            try {
                PropertyPath path = PropertyPath.from((String)pathExpression, (TypeInformation)this.entity.getTypeInformation());
                PersistentPropertyPath propertyPath = this.mappingContext.getPersistentPropertyPath(path);
                Iterator iterator = propertyPath.iterator();
                boolean associationDetected = false;
                while (iterator.hasNext()) {
                    MongoPersistentProperty property = (MongoPersistentProperty)iterator.next();
                    if (property.isAssociation()) {
                        associationDetected = true;
                        continue;
                    }
                    if (!associationDetected || property.isIdProperty()) continue;
                    throw new MappingException(String.format(INVALID_ASSOCIATION_REFERENCE, pathExpression));
                }
                return propertyPath;
            }
            catch (PropertyReferenceException e) {
                return null;
            }
        }

        protected Converter<MongoPersistentProperty, String> getPropertyConverter() {
            return MongoPersistentProperty.PropertyToFieldNameConverter.INSTANCE;
        }

        protected Converter<MongoPersistentProperty, String> getAssociationConverter() {
            return new AssociationConverter(this.getAssociation());
        }
    }

    protected static class Field {
        private static final String ID_KEY = "_id";
        protected final String name;

        public Field(String name) {
            Assert.hasText((String)name, (String)"Name must not be null!");
            this.name = name;
        }

        public Field with(String name) {
            return new Field(name);
        }

        public boolean isIdField() {
            return ID_KEY.equals(this.name);
        }

        public MongoPersistentProperty getProperty() {
            return null;
        }

        public MongoPersistentEntity<?> getPropertyEntity() {
            return null;
        }

        public boolean isAssociation() {
            return false;
        }

        public String getMappedKey() {
            return this.isIdField() ? ID_KEY : this.name;
        }

        public boolean containsAssociation() {
            return false;
        }

        public Association<MongoPersistentProperty> getAssociation() {
            return null;
        }
    }

    static class Keyword {
        private static final String N_OR_PATTERN = "\\$.*or";
        private final String key;
        private final Object value;

        public Keyword(DBObject source, String key) {
            this.key = key;
            this.value = source.get(key);
        }

        public Keyword(DBObject dbObject) {
            Set keys = dbObject.keySet();
            Assert.isTrue((keys.size() == 1 ? 1 : 0) != 0, (String)"Can only use a single value DBObject!");
            this.key = (String)keys.iterator().next();
            this.value = dbObject.get(this.key);
        }

        public boolean isExists() {
            return "$exists".equalsIgnoreCase(this.key);
        }

        public boolean isOrOrNor() {
            return this.key.matches(N_OR_PATTERN);
        }

        public boolean hasIterableValue() {
            return this.value instanceof Iterable;
        }

        public String getKey() {
            return this.key;
        }

        public <T> T getValue() {
            return (T)this.value;
        }
    }

    private static enum MetaMapping {
        FORCE,
        WHEN_PRESENT,
        IGNORE;

    }
}

