/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.convert.QueryMapper;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

public class UpdateMapper
extends QueryMapper {
    private final MongoConverter converter;

    public UpdateMapper(MongoConverter converter) {
        super(converter);
        this.converter = converter;
    }

    @Override
    protected Object delegateConvertToMongoType(Object source, MongoPersistentEntity<?> entity) {
        return this.converter.convertToMongoType(source, (TypeInformation)(entity == null ? ClassTypeInformation.OBJECT : this.getTypeHintForEntity(source, entity)));
    }

    @Override
    protected Map.Entry<String, Object> getMappedObjectForField(QueryMapper.Field field, Object rawValue) {
        if (this.isDBObject(rawValue)) {
            return this.createMapEntry(field, this.convertSimpleOrDBObject(rawValue, field.getPropertyEntity()));
        }
        if (this.isQuery(rawValue)) {
            return this.createMapEntry(field, super.getMappedObject(((Query)rawValue).getQueryObject(), field.getPropertyEntity()));
        }
        if (this.isUpdateModifier(rawValue)) {
            return this.getMappedUpdateModifier(field, rawValue);
        }
        return super.getMappedObjectForField(field, rawValue);
    }

    private Map.Entry<String, Object> getMappedUpdateModifier(QueryMapper.Field field, Object rawValue) {
        DBObject value = null;
        if (rawValue instanceof Update.Modifier) {
            value = this.getMappedValue(field, (Update.Modifier)rawValue);
        } else if (rawValue instanceof Update.Modifiers) {
            BasicDBObject modificationOperations = new BasicDBObject();
            for (Update.Modifier modifier : ((Update.Modifiers)rawValue).getModifiers()) {
                modificationOperations.putAll(this.getMappedValue(field, modifier).toMap());
            }
            value = modificationOperations;
        } else {
            throw new IllegalArgumentException(String.format("Unable to map value of type '%s'!", rawValue.getClass()));
        }
        return this.createMapEntry(field, value);
    }

    @Override
    protected boolean isAssociationConversionNecessary(QueryMapper.Field documentField, Object value) {
        return super.isAssociationConversionNecessary(documentField, value) || documentField.containsAssociation();
    }

    private boolean isUpdateModifier(Object value) {
        return value instanceof Update.Modifier || value instanceof Update.Modifiers;
    }

    private boolean isQuery(Object value) {
        return value instanceof Query;
    }

    private DBObject getMappedValue(QueryMapper.Field field, Update.Modifier modifier) {
        TypeInformation<?> typeHint = field == null ? ClassTypeInformation.OBJECT : field.getTypeHint();
        Object value = this.converter.convertToMongoType(modifier.getValue(), typeHint);
        return new BasicDBObject(modifier.getKey(), value);
    }

    private TypeInformation<?> getTypeHintForEntity(Object source, MongoPersistentEntity<?> entity) {
        TypeInformation info = entity.getTypeInformation();
        Class type = info.getActualType().getType();
        if (source == null || type.isInterface() || Modifier.isAbstract(type.getModifiers())) {
            return info;
        }
        if (!type.equals(source.getClass())) {
            return info;
        }
        return NESTED_DOCUMENT;
    }

    @Override
    protected QueryMapper.Field createPropertyField(MongoPersistentEntity<?> entity, String key, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext) {
        return entity == null ? super.createPropertyField(entity, key, mappingContext) : new MetadataBackedUpdateField(entity, key, mappingContext);
    }

    private static class MetadataBackedUpdateField
    extends QueryMapper.MetadataBackedField {
        private final String key;

        public MetadataBackedUpdateField(MongoPersistentEntity<?> entity, String key, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext) {
            super(key.replaceAll("\\.\\$", ""), entity, mappingContext);
            this.key = key;
        }

        @Override
        public String getMappedKey() {
            return this.getPath() == null ? this.key : super.getMappedKey();
        }

        @Override
        protected Converter<MongoPersistentProperty, String> getPropertyConverter() {
            return new UpdatePropertyConverter(this.key);
        }

        @Override
        protected Converter<MongoPersistentProperty, String> getAssociationConverter() {
            return new UpdateAssociationConverter(this.getAssociation(), this.key);
        }

        protected static class UpdateAssociationConverter
        extends QueryMapper.AssociationConverter {
            private final UpdateKeyMapper mapper;

            public UpdateAssociationConverter(Association<MongoPersistentProperty> association, String key) {
                super(association);
                this.mapper = new UpdateKeyMapper(key);
            }

            @Override
            public String convert(MongoPersistentProperty source) {
                return super.convert(source) == null ? null : this.mapper.mapPropertyName(source);
            }
        }

        private static class UpdatePropertyConverter
        implements Converter<MongoPersistentProperty, String> {
            private final UpdateKeyMapper mapper;

            public UpdatePropertyConverter(String updateKey) {
                Assert.hasText((String)updateKey, (String)"Update key must not be null or empty!");
                this.mapper = new UpdateKeyMapper(updateKey);
            }

            public String convert(MongoPersistentProperty property) {
                return this.mapper.mapPropertyName(property);
            }
        }

        private static class UpdateKeyMapper {
            private final Iterator<String> iterator;

            protected UpdateKeyMapper(String rawKey) {
                Assert.hasText((String)rawKey, (String)"Key must not be null or empty!");
                this.iterator = Arrays.asList(rawKey.split("\\.")).iterator();
                this.iterator.next();
            }

            protected String mapPropertyName(MongoPersistentProperty property) {
                String mappedName = MongoPersistentProperty.PropertyToFieldNameConverter.INSTANCE.convert(property);
                boolean inspect = this.iterator.hasNext();
                while (inspect) {
                    String partial = this.iterator.next();
                    boolean isPositional = this.isPositionalParameter(partial);
                    if (isPositional) {
                        mappedName = mappedName + "." + partial;
                    }
                    inspect = isPositional && this.iterator.hasNext();
                }
                return mappedName;
            }

            boolean isPositionalParameter(String partial) {
                if (partial.equals("$")) {
                    return true;
                }
                try {
                    Long.valueOf(partial);
                    return true;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
        }
    }
}

