/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.query;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import org.bson.BSONObject;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.ObjectUtils;

public class BasicQuery
extends Query {
    private final DBObject queryObject;
    private DBObject fieldsObject;
    private DBObject sortObject;

    public BasicQuery(String query) {
        this((DBObject)JSON.parse((String)query));
    }

    public BasicQuery(DBObject queryObject) {
        this(queryObject, null);
    }

    public BasicQuery(String query, String fields) {
        this.queryObject = (DBObject)JSON.parse((String)query);
        this.fieldsObject = (DBObject)JSON.parse((String)fields);
    }

    public BasicQuery(DBObject queryObject, DBObject fieldsObject) {
        this.queryObject = queryObject;
        this.fieldsObject = fieldsObject;
    }

    @Override
    public Query addCriteria(CriteriaDefinition criteria) {
        this.queryObject.putAll((BSONObject)criteria.getCriteriaObject());
        return this;
    }

    @Override
    public DBObject getQueryObject() {
        return this.queryObject;
    }

    @Override
    public DBObject getFieldsObject() {
        return this.fieldsObject;
    }

    @Override
    public DBObject getSortObject() {
        DBObject overrides;
        BasicDBObject result = new BasicDBObject();
        if (this.sortObject != null) {
            result.putAll((BSONObject)this.sortObject);
        }
        if ((overrides = super.getSortObject()) != null) {
            result.putAll((BSONObject)overrides);
        }
        return result;
    }

    public void setSortObject(DBObject sortObject) {
        this.sortObject = sortObject;
    }

    protected void setFieldsObject(DBObject fieldsObject) {
        this.fieldsObject = fieldsObject;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BasicQuery)) {
            return false;
        }
        BasicQuery that = (BasicQuery)o;
        return this.querySettingsEquals(that) && ObjectUtils.nullSafeEquals((Object)this.fieldsObject, (Object)that.fieldsObject) && ObjectUtils.nullSafeEquals((Object)this.queryObject, (Object)that.queryObject) && ObjectUtils.nullSafeEquals((Object)this.sortObject, (Object)that.sortObject);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.queryObject);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.fieldsObject);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.sortObject);
        return result;
    }
}

