/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.support;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Order;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.mongodb.AbstractMongodbQuery;
import java.io.Serializable;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.repository.query.MongoEntityInformation;
import org.springframework.data.mongodb.repository.support.SimpleMongoRepository;
import org.springframework.data.mongodb.repository.support.SpringDataMongodbQuery;
import org.springframework.data.querydsl.EntityPathResolver;
import org.springframework.data.querydsl.QSort;
import org.springframework.data.querydsl.QueryDslPredicateExecutor;
import org.springframework.data.querydsl.SimpleEntityPathResolver;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.util.Assert;

public class QueryDslMongoRepository<T, ID extends Serializable>
extends SimpleMongoRepository<T, ID>
implements QueryDslPredicateExecutor<T> {
    private final PathBuilder<T> builder;
    private final EntityInformation<T, ID> entityInformation;
    private final MongoOperations mongoOperations;

    public QueryDslMongoRepository(MongoEntityInformation<T, ID> entityInformation, MongoOperations mongoOperations) {
        this(entityInformation, mongoOperations, (EntityPathResolver)SimpleEntityPathResolver.INSTANCE);
    }

    public QueryDslMongoRepository(MongoEntityInformation<T, ID> entityInformation, MongoOperations mongoOperations, EntityPathResolver resolver) {
        super(entityInformation, mongoOperations);
        Assert.notNull((Object)resolver);
        EntityPath path = resolver.createPath(entityInformation.getJavaType());
        this.builder = new PathBuilder(path.getType(), path.getMetadata());
        this.entityInformation = entityInformation;
        this.mongoOperations = mongoOperations;
    }

    @Override
    public T findOne(Predicate predicate) {
        return (T)this.createQueryFor(predicate).fetchOne();
    }

    public List<T> findAll(Predicate predicate) {
        return this.createQueryFor(predicate).fetchResults().getResults();
    }

    public List<T> findAll(Predicate predicate, OrderSpecifier<?> ... orders) {
        return ((SpringDataMongodbQuery)this.createQueryFor(predicate).orderBy(orders)).fetchResults().getResults();
    }

    public List<T> findAll(Predicate predicate, Sort sort) {
        return this.applySorting(this.createQueryFor(predicate), sort).fetchResults().getResults();
    }

    public Iterable<T> findAll(OrderSpecifier<?> ... orders) {
        return ((SpringDataMongodbQuery)this.createQuery().orderBy(orders)).fetchResults().getResults();
    }

    public Page<T> findAll(Predicate predicate, Pageable pageable) {
        AbstractMongodbQuery<T, SpringDataMongodbQuery<T>> countQuery = this.createQueryFor(predicate);
        AbstractMongodbQuery<T, SpringDataMongodbQuery<T>> query = this.createQueryFor(predicate);
        return new PageImpl(this.applyPagination(query, pageable).fetchResults().getResults(), pageable, countQuery.fetchCount());
    }

    @Override
    public Page<T> findAll(Pageable pageable) {
        AbstractMongodbQuery<T, SpringDataMongodbQuery<T>> countQuery = this.createQuery();
        AbstractMongodbQuery<T, SpringDataMongodbQuery<T>> query = this.createQuery();
        return new PageImpl(this.applyPagination(query, pageable).fetchResults().getResults(), pageable, countQuery.fetchCount());
    }

    @Override
    public List<T> findAll(Sort sort) {
        return this.applySorting(this.createQuery(), sort).fetchResults().getResults();
    }

    public long count(Predicate predicate) {
        return this.createQueryFor(predicate).fetchCount();
    }

    @Override
    public boolean exists(Predicate predicate) {
        return this.createQueryFor(predicate).fetchCount() > 0L;
    }

    private AbstractMongodbQuery<T, SpringDataMongodbQuery<T>> createQueryFor(Predicate predicate) {
        return this.createQuery().where(predicate);
    }

    private AbstractMongodbQuery<T, SpringDataMongodbQuery<T>> createQuery() {
        return new SpringDataMongodbQuery(this.mongoOperations, this.entityInformation.getJavaType());
    }

    private AbstractMongodbQuery<T, SpringDataMongodbQuery<T>> applyPagination(AbstractMongodbQuery<T, SpringDataMongodbQuery<T>> query, Pageable pageable) {
        if (pageable == null) {
            return query;
        }
        query = ((SpringDataMongodbQuery)query.offset((long)pageable.getOffset())).limit(pageable.getPageSize());
        return this.applySorting(query, pageable.getSort());
    }

    private AbstractMongodbQuery<T, SpringDataMongodbQuery<T>> applySorting(AbstractMongodbQuery<T, SpringDataMongodbQuery<T>> query, Sort sort) {
        if (sort == null) {
            return query;
        }
        if (sort instanceof QSort) {
            List orderSpecifiers = ((QSort)sort).getOrderSpecifiers();
            query.orderBy(orderSpecifiers.toArray(new OrderSpecifier[orderSpecifiers.size()]));
            return query;
        }
        for (Sort.Order order : sort) {
            query.orderBy(this.toOrder(order));
        }
        return query;
    }

    private OrderSpecifier<?> toOrder(Sort.Order order) {
        PathBuilder property = this.builder.get(order.getProperty());
        return new OrderSpecifier(order.isAscending() ? Order.ASC : Order.DESC, (Expression)property);
    }
}

