/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.BulkWriteException;
import com.mongodb.WriteConcern;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.DeleteManyModel;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.UpdateManyModel;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.DefaultWriteConcernResolver;
import org.springframework.data.mongodb.core.MongoExceptionTranslator;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.WriteConcernResolver;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.util.Pair;
import org.springframework.util.Assert;

class DefaultBulkOperations
implements BulkOperations {
    private final MongoOperations mongoOperations;
    private final BulkOperations.BulkMode bulkMode;
    private final String collectionName;
    private PersistenceExceptionTranslator exceptionTranslator;
    private WriteConcernResolver writeConcernResolver;
    private WriteConcern defaultWriteConcern;
    private BulkWriteOptions bulkOptions;
    List<WriteModel<Document>> models = new ArrayList<WriteModel<Document>>();

    DefaultBulkOperations(MongoOperations mongoOperations, BulkOperations.BulkMode bulkMode, String collectionName, Class<?> entityType) {
        Assert.notNull((Object)mongoOperations, (String)"MongoOperations must not be null!");
        Assert.notNull((Object)((Object)bulkMode), (String)"BulkMode must not be null!");
        Assert.hasText((String)collectionName, (String)"Collection name must not be null or empty!");
        this.mongoOperations = mongoOperations;
        this.bulkMode = bulkMode;
        this.collectionName = collectionName;
        this.exceptionTranslator = new MongoExceptionTranslator();
        this.writeConcernResolver = DefaultWriteConcernResolver.INSTANCE;
        this.bulkOptions = this.initBulkOperation();
    }

    public void setExceptionTranslator(PersistenceExceptionTranslator exceptionTranslator) {
        this.exceptionTranslator = exceptionTranslator == null ? new MongoExceptionTranslator() : exceptionTranslator;
    }

    public void setWriteConcernResolver(WriteConcernResolver writeConcernResolver) {
        this.writeConcernResolver = writeConcernResolver == null ? DefaultWriteConcernResolver.INSTANCE : writeConcernResolver;
    }

    public void setDefaultWriteConcern(WriteConcern defaultWriteConcern) {
        this.defaultWriteConcern = defaultWriteConcern;
    }

    @Override
    public BulkOperations insert(Object document) {
        Assert.notNull((Object)document, (String)"Document must not be null!");
        if (document instanceof Document) {
            this.models.add((WriteModel<Document>)new InsertOneModel((Object)((Document)document)));
            return this;
        }
        Document sink = new Document();
        this.mongoOperations.getConverter().write(document, sink);
        this.models.add((WriteModel<Document>)new InsertOneModel((Object)sink));
        return this;
    }

    @Override
    public BulkOperations insert(List<? extends Object> documents) {
        Assert.notNull(documents, (String)"Documents must not be null!");
        for (Object object : documents) {
            this.insert(object);
        }
        return this;
    }

    @Override
    public BulkOperations updateOne(Query query, Update update) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Assert.notNull((Object)update, (String)"Update must not be null!");
        return this.updateOne(Arrays.asList(Pair.of((Object)query, (Object)update)));
    }

    @Override
    public BulkOperations updateOne(List<Pair<Query, Update>> updates) {
        Assert.notNull(updates, (String)"Updates must not be null!");
        for (Pair<Query, Update> update : updates) {
            this.update((Query)update.getFirst(), (Update)update.getSecond(), false, false);
        }
        return this;
    }

    @Override
    public BulkOperations updateMulti(Query query, Update update) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Assert.notNull((Object)update, (String)"Update must not be null!");
        return this.updateMulti(Arrays.asList(Pair.of((Object)query, (Object)update)));
    }

    @Override
    public BulkOperations updateMulti(List<Pair<Query, Update>> updates) {
        Assert.notNull(updates, (String)"Updates must not be null!");
        for (Pair<Query, Update> update : updates) {
            this.update((Query)update.getFirst(), (Update)update.getSecond(), false, true);
        }
        return this;
    }

    @Override
    public BulkOperations upsert(Query query, Update update) {
        return this.update(query, update, true, true);
    }

    @Override
    public BulkOperations upsert(List<Pair<Query, Update>> updates) {
        for (Pair<Query, Update> update : updates) {
            this.upsert((Query)update.getFirst(), (Update)update.getSecond());
        }
        return this;
    }

    @Override
    public BulkOperations remove(Query query) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        this.models.add((WriteModel<Document>)new DeleteManyModel((Bson)query.getQueryObject()));
        return this;
    }

    @Override
    public BulkOperations remove(List<Query> removes) {
        Assert.notNull(removes, (String)"Removals must not be null!");
        for (Query query : removes) {
            this.remove(query);
        }
        return this;
    }

    @Override
    public BulkWriteResult execute() {
        try {
            MongoCollection collection = this.mongoOperations.getCollection(this.collectionName);
            if (this.defaultWriteConcern != null) {
                collection = collection.withWriteConcern(this.defaultWriteConcern);
            }
            BulkWriteResult bulkWriteResult = collection.bulkWrite(this.models, this.bulkOptions);
            return bulkWriteResult;
        }
        catch (BulkWriteException o_O) {
            DataAccessException toThrow = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)o_O));
            throw toThrow == null ? o_O : toThrow;
        }
        finally {
            this.bulkOptions = this.initBulkOperation();
        }
    }

    private BulkOperations update(Query query, Update update, boolean upsert, boolean multi) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Assert.notNull((Object)update, (String)"Update must not be null!");
        UpdateOptions options = new UpdateOptions();
        options.upsert(upsert);
        if (multi) {
            this.models.add((WriteModel<Document>)new UpdateManyModel((Bson)query.getQueryObject(), (Bson)update.getUpdateObject(), options));
        } else {
            this.models.add((WriteModel<Document>)new UpdateOneModel((Bson)query.getQueryObject(), (Bson)update.getUpdateObject(), options));
        }
        return this;
    }

    private final BulkWriteOptions initBulkOperation() {
        BulkWriteOptions options = new BulkWriteOptions();
        switch (this.bulkMode) {
            case ORDERED: {
                return options.ordered(true);
            }
            case UNORDERED: {
                return options.ordered(false);
            }
        }
        throw new IllegalStateException("BulkMode was null!");
    }
}

