/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.convert.EntityInstantiator;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.AssociationHandler;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.data.mapping.model.DefaultSpELExpressionEvaluator;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.mapping.model.PersistentEntityParameterValueProvider;
import org.springframework.data.mapping.model.PropertyValueProvider;
import org.springframework.data.mapping.model.SpELContext;
import org.springframework.data.mapping.model.SpELExpressionEvaluator;
import org.springframework.data.mapping.model.SpELExpressionParameterValueProvider;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.convert.AbstractMongoConverter;
import org.springframework.data.mongodb.core.convert.DbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultDbRefProxyHandler;
import org.springframework.data.mongodb.core.convert.DefaultDbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultDbRefResolverCallback;
import org.springframework.data.mongodb.core.convert.DefaultMongoTypeMapper;
import org.springframework.data.mongodb.core.convert.DocumentAccessor;
import org.springframework.data.mongodb.core.convert.DocumentPropertyAccessor;
import org.springframework.data.mongodb.core.convert.LazyLoadingProxy;
import org.springframework.data.mongodb.core.convert.MongoTypeMapper;
import org.springframework.data.mongodb.core.convert.ObjectPath;
import org.springframework.data.mongodb.core.convert.QueryMapper;
import org.springframework.data.mongodb.core.convert.ValueResolver;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.mapping.event.AfterConvertEvent;
import org.springframework.data.mongodb.core.mapping.event.AfterLoadEvent;
import org.springframework.data.mongodb.core.mapping.event.MongoMappingEvent;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public class MappingMongoConverter
extends AbstractMongoConverter
implements ApplicationContextAware,
ValueResolver {
    private static final String INCOMPATIBLE_TYPES = "Cannot convert %1$s of type %2$s into an instance of %3$s! Implement a custom Converter<%2$s, %3$s> and register it with the CustomConversions. Parent object was: %4$s";
    protected static final Logger LOGGER = LoggerFactory.getLogger(MappingMongoConverter.class);
    protected final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;
    protected final SpelExpressionParser spelExpressionParser = new SpelExpressionParser();
    protected final QueryMapper idMapper;
    protected final DbRefResolver dbRefResolver;
    protected ApplicationContext applicationContext;
    protected MongoTypeMapper typeMapper;
    protected String mapKeyDotReplacement = null;
    private SpELContext spELContext;

    public MappingMongoConverter(DbRefResolver dbRefResolver, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext) {
        super((GenericConversionService)new DefaultConversionService());
        Assert.notNull((Object)dbRefResolver, (String)"DbRefResolver must not be null!");
        Assert.notNull(mappingContext, (String)"MappingContext must not be null!");
        this.dbRefResolver = dbRefResolver;
        this.mappingContext = mappingContext;
        this.typeMapper = new DefaultMongoTypeMapper("_class", mappingContext);
        this.idMapper = new QueryMapper(this);
        this.spELContext = new SpELContext((PropertyAccessor)DocumentPropertyAccessor.INSTANCE);
    }

    @Deprecated
    public MappingMongoConverter(MongoDbFactory mongoDbFactory, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext) {
        this(new DefaultDbRefResolver(mongoDbFactory), mappingContext);
    }

    public void setTypeMapper(MongoTypeMapper typeMapper) {
        this.typeMapper = typeMapper == null ? new DefaultMongoTypeMapper("_class", this.mappingContext) : typeMapper;
    }

    @Override
    public MongoTypeMapper getTypeMapper() {
        return this.typeMapper;
    }

    public void setMapKeyDotReplacement(String mapKeyDotReplacement) {
        this.mapKeyDotReplacement = mapKeyDotReplacement;
    }

    public MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> getMappingContext() {
        return this.mappingContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        this.spELContext = new SpELContext(this.spELContext, (BeanFactory)applicationContext);
    }

    public <S> S read(Class<S> clazz, Bson bson) {
        return this.read((TypeInformation<S>)ClassTypeInformation.from(clazz), bson);
    }

    protected <S> S read(TypeInformation<S> type, Bson bson) {
        return this.read(type, bson, ObjectPath.ROOT);
    }

    private <S> S read(TypeInformation<S> type, Bson bson, ObjectPath path) {
        if (null == bson) {
            return null;
        }
        TypeInformation typeToUse = this.typeMapper.readType(bson, type);
        Class rawType = typeToUse.getType();
        if (this.conversions.hasCustomReadTarget(bson.getClass(), rawType)) {
            return (S)this.conversionService.convert((Object)bson, rawType);
        }
        if (DBObject.class.isAssignableFrom(rawType)) {
            return (S)bson;
        }
        if (Document.class.isAssignableFrom(rawType)) {
            return (S)bson;
        }
        if (typeToUse.isCollectionLike() && bson instanceof List) {
            return (S)this.readCollectionOrArray(typeToUse, (List)bson, path);
        }
        if (typeToUse.isMap()) {
            return (S)this.readMap(typeToUse, bson, path);
        }
        if (bson instanceof Collection) {
            throw new MappingException(String.format(INCOMPATIBLE_TYPES, bson, BasicDBList.class, typeToUse.getType(), path));
        }
        if (typeToUse.equals(ClassTypeInformation.OBJECT)) {
            return (S)bson;
        }
        Document target = bson instanceof BasicDBObject ? new Document((Map)((BasicDBObject)bson)) : (Document)bson;
        return this.read((MongoPersistentEntity)this.mappingContext.getRequiredPersistentEntity(typeToUse), target, path);
    }

    private ParameterValueProvider<MongoPersistentProperty> getParameterProvider(MongoPersistentEntity<?> entity, Bson source, DefaultSpELExpressionEvaluator evaluator, ObjectPath path) {
        MongoDbPropertyValueProvider provider = new MongoDbPropertyValueProvider(source, (SpELExpressionEvaluator)evaluator, path);
        PersistentEntityParameterValueProvider parameterProvider = new PersistentEntityParameterValueProvider(entity, (PropertyValueProvider)provider, path.getCurrentObject());
        return new ConverterAwareSpELExpressionParameterValueProvider((SpELExpressionEvaluator)evaluator, (ConversionService)this.conversionService, (ParameterValueProvider<MongoPersistentProperty>)parameterProvider, path);
    }

    private <S> S read(final MongoPersistentEntity<S> entity, final Document bson, ObjectPath path) {
        final DefaultSpELExpressionEvaluator evaluator = new DefaultSpELExpressionEvaluator((Object)bson, this.spELContext);
        ParameterValueProvider<MongoPersistentProperty> provider = this.getParameterProvider(entity, (Bson)bson, evaluator, path);
        EntityInstantiator instantiator = this.instantiators.getInstantiatorFor(entity);
        Object instance = instantiator.createInstance(entity, provider);
        ConvertingPropertyAccessor accessor = new ConvertingPropertyAccessor(entity.getPropertyAccessor(instance), (ConversionService)this.conversionService);
        final Optional idProperty = entity.getIdProperty();
        Object result = instance;
        final DocumentAccessor documentAccessor = new DocumentAccessor((Bson)bson);
        Optional<Object> idValue = idProperty.filter(it -> documentAccessor.hasValue((MongoPersistentProperty)it)).map(arg_0 -> this.lambda$read$1(bson, evaluator, path, (PersistentPropertyAccessor)accessor, arg_0));
        final ObjectPath currentPath = path.push(result, entity, idValue.isPresent() ? idProperty.map(it -> bson.get((Object)it.getFieldName())).orElse(null) : null);
        entity.doWithProperties((PropertyHandler)new PropertyHandler<MongoPersistentProperty>((PersistentPropertyAccessor)accessor, bson, evaluator, currentPath){
            final /* synthetic */ PersistentPropertyAccessor val$accessor;
            final /* synthetic */ Document val$bson;
            final /* synthetic */ DefaultSpELExpressionEvaluator val$evaluator;
            final /* synthetic */ ObjectPath val$currentPath;
            {
                this.val$accessor = persistentPropertyAccessor;
                this.val$bson = document;
                this.val$evaluator = defaultSpELExpressionEvaluator;
                this.val$currentPath = objectPath;
            }

            public void doWithPersistentProperty(MongoPersistentProperty prop) {
                if (idProperty != null && idProperty.equals(prop)) {
                    return;
                }
                if (entity.isConstructorArgument(prop) || !documentAccessor.hasValue(prop)) {
                    return;
                }
                this.val$accessor.setProperty((PersistentProperty)prop, MappingMongoConverter.this.getValueInternal(prop, (Bson)this.val$bson, (SpELExpressionEvaluator)this.val$evaluator, this.val$currentPath));
            }
        });
        entity.doWithAssociations((AssociationHandler)new AssociationHandler<MongoPersistentProperty>((PersistentPropertyAccessor)accessor){
            final /* synthetic */ PersistentPropertyAccessor val$accessor;
            {
                this.val$accessor = persistentPropertyAccessor;
            }

            public void doWithAssociation(Association<MongoPersistentProperty> association) {
                MongoPersistentProperty property = (MongoPersistentProperty)association.getInverse();
                Object value = documentAccessor.get(property);
                if (value == null || entity.isConstructorArgument(property)) {
                    return;
                }
                com.mongodb.DBRef dbref = value instanceof com.mongodb.DBRef ? (com.mongodb.DBRef)value : null;
                DefaultDbRefProxyHandler handler = new DefaultDbRefProxyHandler(MappingMongoConverter.this.spELContext, MappingMongoConverter.this.mappingContext, MappingMongoConverter.this);
                DefaultDbRefResolverCallback callback = new DefaultDbRefResolverCallback((Bson)bson, currentPath, (SpELExpressionEvaluator)evaluator, MappingMongoConverter.this);
                this.val$accessor.setProperty((PersistentProperty)property, MappingMongoConverter.this.dbRefResolver.resolveDbRef(property, dbref, callback, handler));
            }
        });
        return (S)result;
    }

    @Override
    public com.mongodb.DBRef toDBRef(Object object, MongoPersistentProperty referringProperty) {
        DBRef annotation = null;
        if (referringProperty != null) {
            annotation = referringProperty.getDBRef();
            Assert.isTrue((annotation != null ? 1 : 0) != 0, (String)"The referenced property has to be mapped with @DBRef!");
        }
        if (object instanceof LazyLoadingProxy) {
            return ((LazyLoadingProxy)object).toDBRef();
        }
        return this.createDBRef(object, referringProperty);
    }

    public void write(Object obj, Bson bson) {
        boolean handledByCustomConverter;
        if (null == obj) {
            return;
        }
        Class entityType = ClassUtils.getUserClass(obj.getClass());
        ClassTypeInformation type = ClassTypeInformation.from((Class)entityType);
        Object target = obj instanceof LazyLoadingProxy ? ((LazyLoadingProxy)obj).getTarget() : obj;
        this.writeInternal(target, bson, Optional.of(type));
        if (this.asMap(bson).containsKey("_is") && this.asMap(bson).get("_id") == null) {
            this.removeFromMap(bson, "_id");
        }
        boolean bl = handledByCustomConverter = this.conversions.getCustomWriteTarget(entityType, Document.class) != null;
        if (!handledByCustomConverter && !(bson instanceof Collection)) {
            this.typeMapper.writeType((TypeInformation)type, bson);
        }
    }

    protected void writeInternal(Object obj, Bson bson, Optional<TypeInformation<?>> typeHint) {
        if (null == obj) {
            return;
        }
        Class<?> entityType = obj.getClass();
        Class<?> customTarget = this.conversions.getCustomWriteTarget(entityType, Document.class);
        if (customTarget != null) {
            Document result = (Document)this.conversionService.convert(obj, Document.class);
            this.addAllToMap(bson, (Map)result);
            return;
        }
        if (Map.class.isAssignableFrom(entityType)) {
            this.writeMapInternal((Map)obj, bson, (TypeInformation<?>)ClassTypeInformation.MAP);
            return;
        }
        if (Collection.class.isAssignableFrom(entityType)) {
            this.writeCollectionInternal((Collection)obj, Optional.of(ClassTypeInformation.LIST), (BasicDBList)bson);
            return;
        }
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityType);
        this.writeInternal(obj, bson, entity);
        this.addCustomTypeKeyIfNecessary(typeHint, obj, bson);
    }

    protected void writeInternal(Object obj, final Bson bson, MongoPersistentEntity<?> entity) {
        if (obj == null) {
            return;
        }
        if (null == entity) {
            throw new MappingException("No mapping metadata found for entity of type " + obj.getClass().getName());
        }
        final PersistentPropertyAccessor accessor = entity.getPropertyAccessor(obj);
        DocumentAccessor dbObjectAccessor = new DocumentAccessor(bson);
        final Optional idProperty = entity.getIdProperty();
        idProperty.ifPresent(prop -> dbObjectAccessor.computeIfAbsent((MongoPersistentProperty)prop, () -> this.idMapper.convertId(accessor.getProperty((PersistentProperty)prop))));
        entity.doWithProperties((PropertyHandler)new PropertyHandler<MongoPersistentProperty>(){

            public void doWithPersistentProperty(MongoPersistentProperty prop) {
                if (idProperty.map(it -> it.equals(prop)).orElse(false).booleanValue() || !prop.isWritable()) {
                    return;
                }
                accessor.getProperty((PersistentProperty)prop).ifPresent(it -> {
                    if (!MappingMongoConverter.this.conversions.isSimpleType(it.getClass())) {
                        MappingMongoConverter.this.writePropertyInternal(it, bson, prop);
                    } else {
                        MappingMongoConverter.this.writeSimpleInternal(it, bson, prop);
                    }
                });
            }
        });
        entity.doWithAssociations((AssociationHandler)new AssociationHandler<MongoPersistentProperty>(){

            public void doWithAssociation(Association<MongoPersistentProperty> association) {
                MongoPersistentProperty inverseProp = (MongoPersistentProperty)association.getInverse();
                accessor.getProperty((PersistentProperty)inverseProp).ifPresent(it -> MappingMongoConverter.this.writePropertyInternal(it, bson, inverseProp));
            }
        });
    }

    protected void writePropertyInternal(Object obj, Bson bson, MongoPersistentProperty prop) {
        Class<?> basicTargetType;
        if (obj == null) {
            return;
        }
        DocumentAccessor accessor = new DocumentAccessor(bson);
        ClassTypeInformation valueType = ClassTypeInformation.from(obj.getClass());
        TypeInformation type = prop.getTypeInformation();
        if (valueType.isCollectionLike()) {
            List<Object> collectionInternal = this.createCollection(MappingMongoConverter.asCollection(obj), prop);
            accessor.put(prop, collectionInternal);
            return;
        }
        if (valueType.isMap()) {
            Bson mapDbObj = this.createMap((Map)obj, prop);
            accessor.put(prop, mapDbObj);
            return;
        }
        if (prop.isDbReference()) {
            com.mongodb.DBRef dbRefObj = null;
            if (obj instanceof LazyLoadingProxy) {
                dbRefObj = ((LazyLoadingProxy)obj).toDBRef();
            }
            com.mongodb.DBRef dBRef = dbRefObj = dbRefObj != null ? dbRefObj : this.createDBRef(obj, prop);
            if (null != dbRefObj) {
                accessor.put(prop, dbRefObj);
                return;
            }
        }
        if (obj instanceof LazyLoadingProxy) {
            obj = ((LazyLoadingProxy)obj).getTarget();
        }
        if ((basicTargetType = this.conversions.getCustomWriteTarget(obj.getClass(), null)) != null) {
            accessor.put(prop, this.conversionService.convert(obj, basicTargetType));
            return;
        }
        Object existingValue = accessor.get(prop);
        Document document = existingValue instanceof Document ? (Document)existingValue : new Document();
        MongoPersistentEntity entity = this.isSubtype(prop.getType(), obj.getClass()) ? (MongoPersistentEntity)this.mappingContext.getRequiredPersistentEntity(obj.getClass()) : (MongoPersistentEntity)this.mappingContext.getRequiredPersistentEntity(type);
        this.writeInternal(obj, (Bson)document, entity);
        this.addCustomTypeKeyIfNecessary(Optional.of(ClassTypeInformation.from((Class)prop.getRawType())), obj, (Bson)document);
        accessor.put(prop, document);
    }

    private boolean isSubtype(Class<?> left, Class<?> right) {
        return left.isAssignableFrom(right) && !left.equals(right);
    }

    private static Collection<?> asCollection(Object source) {
        if (source instanceof Collection) {
            return (Collection)source;
        }
        return source.getClass().isArray() ? CollectionUtils.arrayToList((Object)source) : Collections.singleton(source);
    }

    protected List<Object> createCollection(Collection<?> collection, MongoPersistentProperty property) {
        if (!property.isDbReference()) {
            return this.writeCollectionInternal(collection, Optional.of(property.getTypeInformation()), new BasicDBList());
        }
        ArrayList<Object> dbList = new ArrayList<Object>();
        for (Object element : collection) {
            if (element == null) continue;
            com.mongodb.DBRef dbRef = this.createDBRef(element, property);
            dbList.add(dbRef);
        }
        return dbList;
    }

    protected Bson createMap(Map<Object, Object> map, MongoPersistentProperty property) {
        Assert.notNull(map, (String)"Given map must not be null!");
        Assert.notNull((Object)property, (String)"PersistentProperty must not be null!");
        if (!property.isDbReference()) {
            return this.writeMapInternal(map, (Bson)new Document(), property.getTypeInformation());
        }
        Document document = new Document();
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (this.conversions.isSimpleType(key.getClass())) {
                String simpleKey = this.prepareMapKey(key.toString());
                document.put(simpleKey, value != null ? this.createDBRef(value, property) : null);
                continue;
            }
            throw new MappingException("Cannot use a complex object as a key value.");
        }
        return document;
    }

    private BasicDBList writeCollectionInternal(Collection<?> source, Optional<TypeInformation<?>> type, BasicDBList sink) {
        Optional<TypeInformation<?>> componentType = type.flatMap(it -> it.getComponentType());
        for (Object element : source) {
            Class<?> elementType;
            Class<?> clazz = elementType = element == null ? null : element.getClass();
            if (elementType == null || this.conversions.isSimpleType(elementType)) {
                sink.add(this.getPotentiallyConvertedSimpleWrite(element));
                continue;
            }
            if (element instanceof Collection || elementType.isArray()) {
                sink.add((Object)this.writeCollectionInternal(MappingMongoConverter.asCollection(element), componentType, new BasicDBList()));
                continue;
            }
            Document document = new Document();
            this.writeInternal(element, (Bson)document, componentType);
            sink.add((Object)document);
        }
        return sink;
    }

    protected Bson writeMapInternal(Map<Object, Object> obj, Bson bson, TypeInformation<?> propertyType) {
        for (Map.Entry<Object, Object> entry : obj.entrySet()) {
            Object key = entry.getKey();
            Object val = entry.getValue();
            if (this.conversions.isSimpleType(key.getClass())) {
                String simpleKey = this.prepareMapKey(key);
                if (val == null || this.conversions.isSimpleType(val.getClass())) {
                    this.writeSimpleInternal(val, bson, simpleKey);
                    continue;
                }
                if (val instanceof Collection || val.getClass().isArray()) {
                    this.addToMap(bson, simpleKey, this.writeCollectionInternal(MappingMongoConverter.asCollection(val), propertyType.getMapValueType(), new BasicDBList()));
                    continue;
                }
                Document document = new Document();
                Optional<ClassTypeInformation> valueTypeInfo = propertyType.isMap() ? propertyType.getMapValueType() : Optional.of(ClassTypeInformation.OBJECT);
                this.writeInternal(val, (Bson)document, valueTypeInfo);
                this.addToMap(bson, simpleKey, document);
                continue;
            }
            throw new MappingException("Cannot use a complex object as a key value.");
        }
        return bson;
    }

    private String prepareMapKey(Object key) {
        Assert.notNull((Object)key, (String)"Map key must not be null!");
        String convertedKey = this.potentiallyConvertMapKey(key);
        return this.potentiallyEscapeMapKey(convertedKey);
    }

    protected String potentiallyEscapeMapKey(String source) {
        if (!source.contains(".")) {
            return source;
        }
        if (this.mapKeyDotReplacement == null) {
            throw new MappingException(String.format("Map key %s contains dots but no replacement was configured! Make sure map keys don't contain dots in the first place or configure an appropriate replacement!", source));
        }
        return source.replaceAll("\\.", this.mapKeyDotReplacement);
    }

    private String potentiallyConvertMapKey(Object key) {
        if (key instanceof String) {
            return (String)key;
        }
        return this.conversions.hasCustomWriteTarget(key.getClass(), String.class) ? (String)this.getPotentiallyConvertedSimpleWrite(key) : key.toString();
    }

    protected String potentiallyUnescapeMapKey(String source) {
        return this.mapKeyDotReplacement == null ? source : source.replaceAll(this.mapKeyDotReplacement, "\\.");
    }

    protected void addCustomTypeKeyIfNecessary(Optional<TypeInformation<?>> type, Object value, Bson bson) {
        boolean notTheSameClass;
        Optional<Class> actualType = type.map(it -> it.getActualType()).map(it -> it.getType());
        Class<Object> reference = actualType.orElse(Object.class);
        Class valueType = ClassUtils.getUserClass(value.getClass());
        boolean bl = notTheSameClass = !valueType.equals(reference);
        if (notTheSameClass) {
            this.typeMapper.writeType(valueType, bson);
        }
    }

    private void writeSimpleInternal(Object value, Bson bson, String key) {
        this.addToMap(bson, key, this.getPotentiallyConvertedSimpleWrite(value));
    }

    private void writeSimpleInternal(Object value, Bson bson, MongoPersistentProperty property) {
        DocumentAccessor accessor = new DocumentAccessor(bson);
        accessor.put(property, this.getPotentiallyConvertedSimpleWrite(value));
    }

    private Object getPotentiallyConvertedSimpleWrite(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> customTarget = this.conversions.getCustomWriteTarget(value.getClass(), null);
        if (customTarget != null) {
            return this.conversionService.convert(value, customTarget);
        }
        if (ObjectUtils.isArray((Object)value)) {
            if (value instanceof byte[]) {
                return value;
            }
            return MappingMongoConverter.asCollection(value);
        }
        return Enum.class.isAssignableFrom(value.getClass()) ? ((Enum)value).name() : value;
    }

    private Object getPotentiallyConvertedSimpleRead(Object value, Class<?> target) {
        if (value == null || target == null || target.isAssignableFrom(value.getClass())) {
            return value;
        }
        if (this.conversions.hasCustomReadTarget(value.getClass(), target)) {
            return this.conversionService.convert(value, target);
        }
        if (Enum.class.isAssignableFrom(target)) {
            return Enum.valueOf(target, value.toString());
        }
        return this.conversionService.convert(value, target);
    }

    protected com.mongodb.DBRef createDBRef(Object target, MongoPersistentProperty property) {
        Assert.notNull((Object)target, (String)"Target object must not be null!");
        if (target instanceof com.mongodb.DBRef) {
            return (com.mongodb.DBRef)target;
        }
        Optional targetEntity = this.mappingContext.getPersistentEntity(target.getClass());
        Optional optional = targetEntity = targetEntity.isPresent() ? targetEntity : this.mappingContext.getPersistentEntity((PersistentProperty)property);
        if (null == targetEntity) {
            throw new MappingException("No mapping metadata found for " + target.getClass());
        }
        MongoPersistentEntity entity = (MongoPersistentEntity)targetEntity.orElseThrow(() -> new MappingException("No mapping metadata found for " + target.getClass()));
        Optional idProperty = entity.getIdProperty();
        return idProperty.map(it -> {
            Object id;
            Object object = id = target.getClass().equals(it.getType()) ? target : entity.getPropertyAccessor(target).getProperty((PersistentProperty)it);
            if (null == id) {
                throw new MappingException("Cannot create a reference to an object with a NULL id.");
            }
            return this.dbRefResolver.createDbRef(property == null ? null : property.getDBRef(), entity, this.idMapper.convertId(id instanceof Optional ? (Optional<Object>)id : Optional.ofNullable(id)).orElse(null));
        }).orElseThrow(() -> new MappingException("No id property found on class " + entity.getType()));
    }

    @Override
    public Optional<Object> getValueInternal(MongoPersistentProperty prop, Bson bson, SpELExpressionEvaluator evaluator, ObjectPath path) {
        return new MongoDbPropertyValueProvider(bson, evaluator, path).getPropertyValue(prop);
    }

    private Object readCollectionOrArray(TypeInformation<?> targetType, List sourceValue, ObjectPath path) {
        ArrayList<Object> items;
        Assert.notNull(targetType, (String)"Target type must not be null!");
        Assert.notNull((Object)path, (String)"Object path must not be null!");
        Class<List> collectionType = targetType.getType();
        TypeInformation componentType = (TypeInformation)targetType.getComponentType().orElse(ClassTypeInformation.OBJECT);
        Class rawComponentType = componentType.getType();
        collectionType = Collection.class.isAssignableFrom(collectionType) ? collectionType : List.class;
        Collection<Object> collection = items = targetType.getType().isArray() ? new ArrayList<Object>() : CollectionFactory.createCollection(collectionType, (Class)rawComponentType, (int)sourceValue.size());
        if (sourceValue.isEmpty()) {
            return this.getPotentiallyConvertedSimpleRead(items, collectionType);
        }
        if (!com.mongodb.DBRef.class.equals((Object)rawComponentType) && MappingMongoConverter.isCollectionOfDbRefWhereBulkFetchIsPossible(sourceValue)) {
            return this.bulkReadAndConvertDBRefs(sourceValue, componentType, path, rawComponentType);
        }
        for (Object dbObjItem : sourceValue) {
            if (dbObjItem instanceof com.mongodb.DBRef) {
                items.add(com.mongodb.DBRef.class.equals((Object)rawComponentType) ? dbObjItem : this.readAndConvertDBRef((com.mongodb.DBRef)dbObjItem, componentType, path, rawComponentType));
                continue;
            }
            if (dbObjItem instanceof Document) {
                items.add(this.read(componentType, (Bson)((Document)dbObjItem), path));
                continue;
            }
            if (dbObjItem instanceof BasicDBObject) {
                items.add(this.read(componentType, (Bson)((BasicDBObject)dbObjItem), path));
                continue;
            }
            if (dbObjItem instanceof Collection && !rawComponentType.isArray() && !ClassUtils.isAssignable(Iterable.class, (Class)rawComponentType)) {
                throw new MappingException(String.format(INCOMPATIBLE_TYPES, dbObjItem, dbObjItem.getClass(), rawComponentType, path));
            }
            if (dbObjItem instanceof List) {
                items.add(this.readCollectionOrArray((TypeInformation<?>)ClassTypeInformation.OBJECT, (List)dbObjItem, path));
                continue;
            }
            items.add(this.getPotentiallyConvertedSimpleRead(dbObjItem, rawComponentType));
        }
        return this.getPotentiallyConvertedSimpleRead(items, targetType.getType());
    }

    protected Map<Object, Object> readMap(TypeInformation<?> type, Bson bson, ObjectPath path) {
        Assert.notNull((Object)bson, (String)"Document must not be null!");
        Assert.notNull((Object)path, (String)"Object path must not be null!");
        Class mapType = this.typeMapper.readType(bson, type).getType();
        Optional valueType = type.getMapValueType();
        Class rawKeyType = type.getComponentType().map(it -> it.getType()).orElse(null);
        Class rawValueType = type.getMapValueType().map(it -> it.getType()).orElse(null);
        Map<String, Object> sourceMap = this.asMap(bson);
        Map map = CollectionFactory.createMap((Class)mapType, (Class)rawKeyType, (int)sourceMap.keySet().size());
        if (!com.mongodb.DBRef.class.equals((Object)rawValueType) && MappingMongoConverter.isCollectionOfDbRefWhereBulkFetchIsPossible(sourceMap.values())) {
            this.bulkReadAndConvertDBRefMapIntoTarget(valueType.orElse(null), rawValueType, sourceMap, map);
            return map;
        }
        for (Map.Entry<String, Object> entry : sourceMap.entrySet()) {
            if (this.typeMapper.isTypeKey(entry.getKey())) continue;
            Object key = this.potentiallyUnescapeMapKey(entry.getKey());
            if (rawKeyType != null) {
                key = this.conversionService.convert(key, rawKeyType);
            }
            Object value = entry.getValue();
            TypeInformation defaultedValueType = (TypeInformation)valueType.orElse(ClassTypeInformation.OBJECT);
            if (value instanceof Document) {
                map.put(key, this.read(defaultedValueType, (Bson)((Document)value), path));
                continue;
            }
            if (value instanceof BasicDBObject) {
                map.put(key, this.read(defaultedValueType, (Bson)((BasicDBObject)value), path));
                continue;
            }
            if (value instanceof com.mongodb.DBRef) {
                map.put(key, com.mongodb.DBRef.class.equals((Object)rawValueType) ? value : this.readAndConvertDBRef((com.mongodb.DBRef)value, defaultedValueType, ObjectPath.ROOT, rawValueType));
                continue;
            }
            if (value instanceof List) {
                map.put(key, this.readCollectionOrArray((TypeInformation)valueType.orElse(ClassTypeInformation.LIST), (List)value, path));
                continue;
            }
            map.put(key, this.getPotentiallyConvertedSimpleRead(value, rawValueType));
        }
        return map;
    }

    private Map<String, Object> asMap(Bson bson) {
        if (bson instanceof Document) {
            return (Document)bson;
        }
        if (bson instanceof DBObject) {
            return ((DBObject)bson).toMap();
        }
        throw new IllegalArgumentException(String.format("Cannot read %s. as map. Given Bson must be a Document or DBObject!", bson.getClass()));
    }

    private void addToMap(Bson bson, String key, Object value) {
        if (bson instanceof Document) {
            ((Document)bson).put(key, value);
            return;
        }
        if (bson instanceof DBObject) {
            ((DBObject)bson).put(key, value);
            return;
        }
        throw new IllegalArgumentException(String.format("Cannot add key/value pair to %s. as map. Given Bson must be a Document or DBObject!", bson.getClass()));
    }

    private void addAllToMap(Bson bson, Map value) {
        if (bson instanceof Document) {
            ((Document)bson).putAll(value);
            return;
        }
        if (bson instanceof DBObject) {
            ((DBObject)bson).putAll(value);
            return;
        }
        throw new IllegalArgumentException(String.format("Cannot add all to %s. Given Bson must be a Document or DBObject.", bson.getClass()));
    }

    private void removeFromMap(Bson bson, String key) {
        if (bson instanceof Document) {
            ((Document)bson).remove((Object)key);
            return;
        }
        if (bson instanceof DBObject) {
            ((DBObject)bson).removeField(key);
            return;
        }
        throw new IllegalArgumentException(String.format("Cannot remove from %s. Given Bson must be a Document or DBObject.", bson.getClass()));
    }

    @Override
    public Object convertToMongoType(Object obj, TypeInformation<?> typeInformation) {
        if (obj == null) {
            return null;
        }
        Class<?> target = this.conversions.getCustomWriteTarget(obj.getClass());
        if (target != null) {
            return this.conversionService.convert(obj, target);
        }
        if (this.conversions.isSimpleType(obj.getClass())) {
            return this.getPotentiallyConvertedSimpleWrite(obj);
        }
        TypeInformation<?> typeHint = typeInformation;
        if (obj instanceof List) {
            return this.maybeConvertList((List)obj, typeHint);
        }
        if (obj instanceof Document) {
            Document newValueDocument = new Document();
            for (String vk : ((Document)obj).keySet()) {
                Object o = ((Document)obj).get((Object)vk);
                newValueDocument.put(vk, this.convertToMongoType(o, typeHint));
            }
            return newValueDocument;
        }
        if (obj instanceof DBObject) {
            Document newValueDbo = new Document();
            for (String vk : ((DBObject)obj).keySet()) {
                Object o = ((DBObject)obj).get(vk);
                newValueDbo.put(vk, this.convertToMongoType(o, typeHint));
            }
            return newValueDbo;
        }
        if (obj instanceof Map) {
            LinkedHashMap converted = new LinkedHashMap();
            Document result = new Document();
            for (Map.Entry entry : ((Map)obj).entrySet()) {
                result.put(entry.getKey().toString(), this.convertToMongoType(entry.getValue(), typeHint));
            }
            return result;
        }
        if (obj.getClass().isArray()) {
            return this.maybeConvertList(Arrays.asList((Object[])obj), typeHint);
        }
        if (obj instanceof Collection) {
            return this.maybeConvertList((Collection)obj, typeHint);
        }
        Document newDocument = new Document();
        this.write(obj, (Bson)newDocument);
        if (typeInformation == null) {
            return this.removeTypeInfo(newDocument, true);
        }
        if (typeInformation.getType().equals(NestedDocument.class)) {
            return this.removeTypeInfo(newDocument, false);
        }
        return !obj.getClass().equals(typeInformation.getType()) ? newDocument : this.removeTypeInfo(newDocument, true);
    }

    public List<Object> maybeConvertList(Iterable<?> source, TypeInformation<?> typeInformation) {
        ArrayList<Object> newDbl = new ArrayList<Object>();
        for (Object element : source) {
            newDbl.add(this.convertToMongoType(element, typeInformation));
        }
        return newDbl;
    }

    private Object removeTypeInfo(Object object, boolean recursively) {
        if (!(object instanceof Document)) {
            return object;
        }
        Document document = (Document)object;
        String keyToRemove = null;
        for (String key : document.keySet()) {
            if (recursively) {
                Object value = document.get((Object)key);
                if (value instanceof BasicDBList) {
                    for (Object element : (BasicDBList)value) {
                        this.removeTypeInfo(element, recursively);
                    }
                } else if (value instanceof List) {
                    for (Object element : (List)value) {
                        this.removeTypeInfo(element, recursively);
                    }
                } else {
                    this.removeTypeInfo(value, recursively);
                }
            }
            if (!this.typeMapper.isTypeKey(key)) continue;
            keyToRemove = key;
            if (recursively) continue;
            break;
        }
        if (keyToRemove != null) {
            document.remove(keyToRemove);
        }
        return document;
    }

    private <T> T readValue(Object value, TypeInformation<?> type, ObjectPath path) {
        Class rawType = type.getType();
        if (this.conversions.hasCustomReadTarget(value.getClass(), rawType)) {
            return (T)this.conversionService.convert(value, rawType);
        }
        if (value instanceof com.mongodb.DBRef) {
            return this.potentiallyReadOrResolveDbRef((com.mongodb.DBRef)value, type, path, rawType);
        }
        if (value instanceof List) {
            return (T)this.readCollectionOrArray(type, (List)value, path);
        }
        if (value instanceof Document) {
            return (T)this.read(type, (Bson)((Document)value), path);
        }
        if (value instanceof DBObject) {
            return (T)this.read(type, (Bson)((BasicDBObject)value), path);
        }
        return (T)this.getPotentiallyConvertedSimpleRead(value, rawType);
    }

    private <T> T potentiallyReadOrResolveDbRef(com.mongodb.DBRef dbref, TypeInformation<?> type, ObjectPath path, Class<?> rawType) {
        if (rawType.equals(com.mongodb.DBRef.class)) {
            return (T)dbref;
        }
        Object object = dbref == null ? null : path.getPathItem(dbref.getId(), dbref.getCollectionName());
        return (T)(object != null ? object : this.readAndConvertDBRef(dbref, type, path, rawType));
    }

    private <T> T readAndConvertDBRef(com.mongodb.DBRef dbref, TypeInformation<?> type, ObjectPath path, Class<?> rawType) {
        List<T> result = this.bulkReadAndConvertDBRefs(Collections.singletonList(dbref), type, path, rawType);
        return CollectionUtils.isEmpty(result) ? null : (T)result.iterator().next();
    }

    private void bulkReadAndConvertDBRefMapIntoTarget(TypeInformation<?> valueType, Class<?> rawValueType, Map<String, Object> sourceMap, Map<Object, Object> targetMap) {
        LinkedHashMap<String, Object> referenceMap = new LinkedHashMap<String, Object>(sourceMap);
        List convertedObjects = this.bulkReadAndConvertDBRefs(new ArrayList<Object>(referenceMap.values()), valueType, ObjectPath.ROOT, rawValueType);
        int index = 0;
        for (String key : referenceMap.keySet()) {
            targetMap.put(key, convertedObjects.get(index));
            ++index;
        }
    }

    private <T> List<T> bulkReadAndConvertDBRefs(List<com.mongodb.DBRef> dbrefs, TypeInformation<?> type, ObjectPath path, Class<?> rawType) {
        if (CollectionUtils.isEmpty(dbrefs)) {
            return Collections.emptyList();
        }
        List<Document> referencedRawDocuments = dbrefs.size() == 1 ? Collections.singletonList(this.readRef(dbrefs.iterator().next())) : this.bulkReadRefs(dbrefs);
        String collectionName = dbrefs.iterator().next().getCollectionName();
        ArrayList targeList = new ArrayList(dbrefs.size());
        for (Document document : referencedRawDocuments) {
            if (document != null) {
                this.maybeEmitEvent(new AfterLoadEvent(document, rawType, collectionName));
            }
            Object target = this.read(type, (Bson)document, path);
            targeList.add(target);
            if (target == null) continue;
            this.maybeEmitEvent(new AfterConvertEvent(document, target, collectionName));
        }
        return targeList;
    }

    private void maybeEmitEvent(MongoMappingEvent<?> event) {
        if (this.canPublishEvent()) {
            this.applicationContext.publishEvent(event);
        }
    }

    private boolean canPublishEvent() {
        return this.applicationContext != null;
    }

    Document readRef(com.mongodb.DBRef ref) {
        return this.dbRefResolver.fetch(ref);
    }

    List<Document> bulkReadRefs(List<com.mongodb.DBRef> references) {
        return this.dbRefResolver.bulkFetch(references);
    }

    private static boolean isCollectionOfDbRefWhereBulkFetchIsPossible(Iterable<Object> source) {
        Assert.notNull(source, (String)"Iterable of DBRefs must not be null!");
        HashSet<String> collectionsFound = new HashSet<String>();
        for (Object dbObjItem : source) {
            if (!(dbObjItem instanceof com.mongodb.DBRef)) {
                return false;
            }
            collectionsFound.add(((com.mongodb.DBRef)dbObjItem).getCollectionName());
            if (collectionsFound.size() <= 1) continue;
            return false;
        }
        return true;
    }

    private /* synthetic */ Object lambda$read$1(Document bson, DefaultSpELExpressionEvaluator evaluator, ObjectPath path, PersistentPropertyAccessor accessor, MongoPersistentProperty it) {
        Optional<Object> value = this.getValueInternal(it, (Bson)bson, (SpELExpressionEvaluator)evaluator, path);
        accessor.setProperty((PersistentProperty)it, value);
        return value;
    }

    static class NestedDocument {
        NestedDocument() {
        }
    }

    private class ConverterAwareSpELExpressionParameterValueProvider
    extends SpELExpressionParameterValueProvider<MongoPersistentProperty> {
        private final ObjectPath path;

        public ConverterAwareSpELExpressionParameterValueProvider(SpELExpressionEvaluator evaluator, ConversionService conversionService, ParameterValueProvider<MongoPersistentProperty> delegate, ObjectPath path) {
            super(evaluator, conversionService, delegate);
            this.path = path;
        }

        protected <T> T potentiallyConvertSpelValue(Object object, PreferredConstructor.Parameter<T, MongoPersistentProperty> parameter) {
            return (T)MappingMongoConverter.this.readValue(object, parameter.getType(), this.path);
        }
    }

    private class MongoDbPropertyValueProvider
    implements PropertyValueProvider<MongoPersistentProperty> {
        private final DocumentAccessor source;
        private final SpELExpressionEvaluator evaluator;
        private final ObjectPath path;

        public MongoDbPropertyValueProvider(Bson source, SpELExpressionEvaluator evaluator, ObjectPath path) {
            Assert.notNull((Object)source, (String)"Source document must no be null!");
            Assert.notNull((Object)evaluator, (String)"SpELExpressionEvaluator must not be null!");
            Assert.notNull((Object)path, (String)"ObjectPath must not be null!");
            this.source = new DocumentAccessor(source);
            this.evaluator = evaluator;
            this.path = path;
        }

        public <T> Optional<T> getPropertyValue(MongoPersistentProperty property) {
            return Optional.ofNullable(property.getSpelExpression().map(it -> this.evaluator.evaluate(it)).orElseGet(() -> this.source.get(property))).map(it -> MappingMongoConverter.this.readValue(it, property.getTypeInformation(), this.path));
        }
    }
}

