/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Pattern;
import org.bson.Document;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.query.MongoRegexCreator;
import org.springframework.data.mongodb.core.query.SerializationUtils;
import org.springframework.data.repository.core.support.ExampleMatcherAccessor;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class MongoExampleMapper {
    private final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;
    private final MongoConverter converter;
    private final Map<ExampleMatcher.StringMatcher, Part.Type> stringMatcherPartMapping = new HashMap<ExampleMatcher.StringMatcher, Part.Type>();

    public MongoExampleMapper(MongoConverter converter) {
        this.converter = converter;
        this.mappingContext = converter.getMappingContext();
        this.stringMatcherPartMapping.put(ExampleMatcher.StringMatcher.EXACT, Part.Type.SIMPLE_PROPERTY);
        this.stringMatcherPartMapping.put(ExampleMatcher.StringMatcher.CONTAINING, Part.Type.CONTAINING);
        this.stringMatcherPartMapping.put(ExampleMatcher.StringMatcher.STARTING, Part.Type.STARTING_WITH);
        this.stringMatcherPartMapping.put(ExampleMatcher.StringMatcher.ENDING, Part.Type.ENDING_WITH);
        this.stringMatcherPartMapping.put(ExampleMatcher.StringMatcher.REGEX, Part.Type.REGEX);
    }

    public Document getMappedExample(Example<?> example) {
        Assert.notNull(example, (String)"Example must not be null!");
        return this.getMappedExample(example, (MongoPersistentEntity)this.mappingContext.getRequiredPersistentEntity(example.getProbeType()));
    }

    public Document getMappedExample(Example<?> example, MongoPersistentEntity<?> entity) {
        Assert.notNull(example, (String)"Example must not be null!");
        Assert.notNull(entity, (String)"MongoPersistentEntity must not be null!");
        Document reference = (Document)this.converter.convertToMongoType(example.getProbe());
        if (entity.getIdProperty().isPresent() && !entity.getIdentifierAccessor(example.getProbe()).getIdentifier().isPresent()) {
            reference.remove((Object)((MongoPersistentProperty)entity.getIdProperty().get()).getFieldName());
        }
        ExampleMatcherAccessor matcherAccessor = new ExampleMatcherAccessor(example.getMatcher());
        this.applyPropertySpecs("", reference, example.getProbeType(), matcherAccessor);
        Document flattened = ObjectUtils.nullSafeEquals((Object)ExampleMatcher.NullHandler.INCLUDE, (Object)matcherAccessor.getNullHandler()) ? reference : new Document(SerializationUtils.flattenMap(reference));
        Document result = example.getMatcher().isAllMatching() ? flattened : MongoExampleMapper.orConcatenate(flattened);
        this.converter.getTypeMapper().writeTypeRestrictions(result, this.getTypesToMatch(example));
        return result;
    }

    private static Document orConcatenate(Document source) {
        ArrayList<Document> foo = new ArrayList<Document>(source.keySet().size());
        for (String key : source.keySet()) {
            foo.add(new Document(key, source.get((Object)key)));
        }
        return new Document("$or", foo);
    }

    private Set<Class<?>> getTypesToMatch(Example<?> example) {
        HashSet types = new HashSet();
        for (TypeInformation reference : this.mappingContext.getManagedTypes()) {
            if (!example.getProbeType().isAssignableFrom(reference.getType())) continue;
            types.add(reference.getType());
        }
        return types;
    }

    private String getMappedPropertyPath(String path, Class<?> probeType) {
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getRequiredPersistentEntity(probeType);
        Iterator<String> parts = Arrays.asList(path.split("\\.")).iterator();
        Stack stack = new Stack();
        ArrayList<String> resultParts = new ArrayList<String>();
        while (parts.hasNext()) {
            String part = parts.next();
            MongoPersistentProperty prop = entity.getPersistentProperty(part).orElse(null);
            if (prop == null) {
                entity.doWithProperties(property -> {
                    if (property.getFieldName().equals(part)) {
                        stack.push(property);
                    }
                });
                if (stack.isEmpty()) {
                    return "";
                }
                prop = (MongoPersistentProperty)stack.pop();
            }
            resultParts.add(prop.getName());
            if (!prop.isEntity() || !this.mappingContext.hasPersistentEntityFor(prop.getActualType())) break;
            entity = (MongoPersistentEntity)this.mappingContext.getRequiredPersistentEntity(prop.getActualType());
        }
        return StringUtils.collectionToDelimitedString(resultParts, (String)".");
    }

    private void applyPropertySpecs(String path, Document source, Class<?> probeType, ExampleMatcherAccessor exampleSpecAccessor) {
        if (!(source instanceof Document)) {
            return;
        }
        Iterator iter = source.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            String propertyPath = StringUtils.hasText((String)path) ? path + "." + (String)entry.getKey() : (String)entry.getKey();
            String mappedPropertyPath = this.getMappedPropertyPath(propertyPath, probeType);
            if (this.isEmptyIdProperty(entry)) {
                iter.remove();
                continue;
            }
            if (exampleSpecAccessor.isIgnoredPath(propertyPath) || exampleSpecAccessor.isIgnoredPath(mappedPropertyPath)) {
                iter.remove();
                continue;
            }
            ExampleMatcher.StringMatcher stringMatcher = exampleSpecAccessor.getDefaultStringMatcher();
            Object value = entry.getValue();
            boolean ignoreCase = exampleSpecAccessor.isIgnoreCaseEnabled();
            if (exampleSpecAccessor.hasPropertySpecifiers()) {
                mappedPropertyPath = exampleSpecAccessor.hasPropertySpecifier(propertyPath) ? propertyPath : this.getMappedPropertyPath(propertyPath, probeType);
                stringMatcher = exampleSpecAccessor.getStringMatcherForPath(mappedPropertyPath);
                ignoreCase = exampleSpecAccessor.isIgnoreCaseForPath(mappedPropertyPath);
            }
            if (exampleSpecAccessor.hasPropertySpecifier(mappedPropertyPath)) {
                ExampleMatcher.PropertyValueTransformer valueTransformer = exampleSpecAccessor.getValueTransformerForPath(mappedPropertyPath);
                value = valueTransformer.convert(value);
                if (value == null) {
                    iter.remove();
                    continue;
                }
                entry.setValue(value);
            }
            if (entry.getValue() instanceof String) {
                this.applyStringMatcher(entry, stringMatcher, ignoreCase);
                continue;
            }
            if (!(entry.getValue() instanceof Document)) continue;
            this.applyPropertySpecs(propertyPath, (Document)entry.getValue(), probeType, exampleSpecAccessor);
        }
    }

    private boolean isEmptyIdProperty(Map.Entry<String, Object> entry) {
        return entry.getKey().equals("_id") && entry.getValue() == null || entry.getValue().equals(Optional.empty());
    }

    private void applyStringMatcher(Map.Entry<String, Object> entry, ExampleMatcher.StringMatcher stringMatcher, boolean ignoreCase) {
        Document document = new Document();
        if (ObjectUtils.nullSafeEquals((Object)ExampleMatcher.StringMatcher.DEFAULT, (Object)stringMatcher)) {
            if (ignoreCase) {
                document.put("$regex", (Object)Pattern.quote((String)entry.getValue()));
                entry.setValue(document);
            }
        } else {
            Part.Type type = this.stringMatcherPartMapping.get(stringMatcher);
            String expression = MongoRegexCreator.INSTANCE.toRegularExpression((String)entry.getValue(), type);
            document.put("$regex", (Object)expression);
            entry.setValue(document);
        }
        if (ignoreCase) {
            document.put("$options", (Object)"i");
        }
    }
}

