/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.mapreduce;

import org.bson.Document;

public class GroupBy {
    private Document dboKeys;
    private String keyFunction;
    private String initial;
    private Document initialDocument;
    private String reduce;
    private String finalize;

    public GroupBy(String ... keys) {
        Document document = new Document();
        for (String key : keys) {
            document.put(key, (Object)1);
        }
        this.dboKeys = document;
    }

    public GroupBy(String key, boolean isKeyFunction) {
        Document document = new Document();
        if (isKeyFunction) {
            this.keyFunction = key;
        } else {
            document.put(key, (Object)1);
            this.dboKeys = document;
        }
    }

    public static GroupBy keyFunction(String key) {
        return new GroupBy(key, true);
    }

    public static GroupBy key(String ... keys) {
        return new GroupBy(keys);
    }

    public GroupBy initialDocument(String initialDocument) {
        this.initial = initialDocument;
        return this;
    }

    public GroupBy initialDocument(Document initialDocument) {
        this.initialDocument = initialDocument;
        return this;
    }

    public GroupBy reduceFunction(String reduceFunction) {
        this.reduce = reduceFunction;
        return this;
    }

    public GroupBy finalizeFunction(String finalizeFunction) {
        this.finalize = finalizeFunction;
        return this;
    }

    public Document getGroupByObject() {
        Document document = new Document();
        if (this.dboKeys != null) {
            document.put("key", (Object)this.dboKeys);
        }
        if (this.keyFunction != null) {
            document.put("$keyf", (Object)this.keyFunction);
        }
        document.put("$reduce", (Object)this.reduce);
        document.put("initial", (Object)this.initialDocument);
        if (this.initial != null) {
            document.put("initial", (Object)this.initial);
        }
        if (this.finalize != null) {
            document.put("finalize", (Object)this.finalize);
        }
        return document;
    }
}

