/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.support;

import java.io.Serializable;
import org.bson.types.ObjectId;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.repository.query.MongoEntityInformation;
import org.springframework.data.repository.core.support.PersistentEntityInformation;

public class MappingMongoEntityInformation<T, ID extends Serializable>
extends PersistentEntityInformation<T, ID>
implements MongoEntityInformation<T, ID> {
    private final MongoPersistentEntity<T> entityMetadata;
    private final String customCollectionName;
    private final Class<ID> fallbackIdType;

    public MappingMongoEntityInformation(MongoPersistentEntity<T> entity) {
        this(entity, null, null);
    }

    public MappingMongoEntityInformation(MongoPersistentEntity<T> entity, Class<ID> fallbackIdType) {
        this(entity, null, fallbackIdType);
    }

    public MappingMongoEntityInformation(MongoPersistentEntity<T> entity, String customCollectionName) {
        this(entity, customCollectionName, null);
    }

    private MappingMongoEntityInformation(MongoPersistentEntity<T> entity, String customCollectionName, Class<ID> idType) {
        super(entity);
        this.entityMetadata = entity;
        this.customCollectionName = customCollectionName;
        this.fallbackIdType = idType != null ? idType : ObjectId.class;
    }

    @Override
    public String getCollectionName() {
        return this.customCollectionName == null ? this.entityMetadata.getCollection() : this.customCollectionName;
    }

    @Override
    public String getIdAttribute() {
        return ((MongoPersistentProperty)this.entityMetadata.getIdProperty().get()).getName();
    }

    public Class<ID> getIdType() {
        if (this.entityMetadata.hasIdProperty()) {
            return super.getIdType();
        }
        return this.fallbackIdType != null ? this.fallbackIdType : ObjectId.class;
    }
}

