/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.support;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.reactivestreams.Publisher;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.ReactiveMongoOperations;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.repository.ReactiveMongoRepository;
import org.springframework.data.mongodb.repository.query.MongoEntityInformation;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class SimpleReactiveMongoRepository<T, ID extends Serializable>
implements ReactiveMongoRepository<T, ID> {
    private final ReactiveMongoOperations mongoOperations;
    private final MongoEntityInformation<T, ID> entityInformation;

    public SimpleReactiveMongoRepository(MongoEntityInformation<T, ID> metadata, ReactiveMongoOperations mongoOperations) {
        Assert.notNull(metadata, (String)"MongoEntityInformation must not be null!");
        Assert.notNull((Object)mongoOperations, (String)"ReactiveMongoOperations must not be null!");
        this.entityInformation = metadata;
        this.mongoOperations = mongoOperations;
    }

    public Mono<T> findOne(ID id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        return this.mongoOperations.findById(id, this.entityInformation.getJavaType(), this.entityInformation.getCollectionName());
    }

    public Mono<T> findOne(Mono<ID> mono) {
        Assert.notNull(mono, (String)"The given id must not be null!");
        return mono.then(id -> this.mongoOperations.findById(id, this.entityInformation.getJavaType(), this.entityInformation.getCollectionName()));
    }

    public <S extends T> Mono<S> findOne(Example<S> example) {
        Assert.notNull(example, (String)"Sample must not be null!");
        Query q = new Query(new Criteria().alike(example));
        return this.mongoOperations.findOne(q, example.getProbeType(), this.entityInformation.getCollectionName());
    }

    public Mono<Boolean> exists(ID id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        return this.mongoOperations.exists(this.getIdQuery(id), this.entityInformation.getJavaType(), this.entityInformation.getCollectionName());
    }

    public Mono<Boolean> exists(Mono<ID> mono) {
        Assert.notNull(mono, (String)"The given id must not be null!");
        return mono.then(id -> this.mongoOperations.exists(this.getIdQuery(id), this.entityInformation.getJavaType(), this.entityInformation.getCollectionName()));
    }

    public <S extends T> Mono<Boolean> exists(Example<S> example) {
        Assert.notNull(example, (String)"Sample must not be null!");
        Query q = new Query(new Criteria().alike(example));
        return this.mongoOperations.exists(q, example.getProbeType(), this.entityInformation.getCollectionName());
    }

    public Flux<T> findAll() {
        return this.findAll(new Query());
    }

    @Override
    public Flux<T> findAll(Iterable<ID> ids) {
        Assert.notNull(ids, (String)"The given Iterable of Id's must not be null!");
        HashSet<Serializable> parameters = new HashSet<Serializable>(SimpleReactiveMongoRepository.tryDetermineRealSizeOrReturn(ids, 10));
        for (Serializable id : ids) {
            parameters.add(id);
        }
        return this.findAll(new Query(new Criteria(this.entityInformation.getIdAttribute()).in(parameters)));
    }

    @Override
    public Flux<T> findAll(Publisher<ID> idStream) {
        Assert.notNull(idStream, (String)"The given Publisher of Id's must not be null!");
        return Flux.from(idStream).buffer().flatMap(this::findAll);
    }

    public Flux<T> findAll(Sort sort) {
        return this.findAll(new Query().with(sort));
    }

    @Override
    public <S extends T> Flux<S> findAll(Example<S> example, Sort sort) {
        Assert.notNull(example, (String)"Sample must not be null!");
        Query q = new Query(new Criteria().alike(example));
        if (sort != null) {
            q.with(sort);
        }
        return this.mongoOperations.find(q, example.getProbeType(), this.entityInformation.getCollectionName());
    }

    @Override
    public <S extends T> Flux<S> findAll(Example<S> example) {
        return this.findAll(example, null);
    }

    public Mono<Long> count() {
        return this.mongoOperations.count(new Query(), this.entityInformation.getCollectionName());
    }

    public <S extends T> Mono<Long> count(Example<S> example) {
        Assert.notNull(example, (String)"Sample must not be null!");
        Query q = new Query(new Criteria().alike(example));
        return this.mongoOperations.count(q, example.getProbeType(), this.entityInformation.getCollectionName());
    }

    @Override
    public <S extends T> Mono<S> insert(S entity) {
        Assert.notNull(entity, (String)"Entity must not be null!");
        return this.mongoOperations.insert(entity, this.entityInformation.getCollectionName());
    }

    @Override
    public <S extends T> Flux<S> insert(Iterable<S> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities must not be null!");
        List<S> list = SimpleReactiveMongoRepository.convertIterableToList(entities);
        if (list.isEmpty()) {
            return Flux.empty();
        }
        return Flux.from(this.mongoOperations.insertAll(list));
    }

    @Override
    public <S extends T> Flux<S> insert(Publisher<S> entities) {
        Assert.notNull(entities, (String)"The given Publisher of entities must not be null!");
        return Flux.from(entities).flatMap(entity -> this.mongoOperations.insert(entity, this.entityInformation.getCollectionName()));
    }

    public <S extends T> Mono<S> save(S entity) {
        Assert.notNull(entity, (String)"Entity must not be null!");
        if (this.entityInformation.isNew(entity)) {
            return this.mongoOperations.insert(entity, this.entityInformation.getCollectionName());
        }
        return this.mongoOperations.save(entity, this.entityInformation.getCollectionName());
    }

    public <S extends T> Flux<S> save(Iterable<S> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities must not be null!");
        List<S> result = SimpleReactiveMongoRepository.convertIterableToList(entities);
        boolean allNew = true;
        for (S entity : entities) {
            if (!allNew || this.entityInformation.isNew(entity)) continue;
            allNew = false;
        }
        if (allNew) {
            return Flux.from(this.mongoOperations.insertAll(result));
        }
        ArrayList<Mono<S>> monos = new ArrayList<Mono<S>>();
        for (S entity : result) {
            monos.add(this.save(entity));
        }
        return Flux.merge(monos);
    }

    public <S extends T> Flux<S> save(Publisher<S> entityStream) {
        Assert.notNull(entityStream, (String)"The given Publisher of entities must not be null!");
        return Flux.from(entityStream).flatMap(entity -> {
            if (this.entityInformation.isNew(entity)) {
                return this.mongoOperations.insert(entity, this.entityInformation.getCollectionName()).then(aVoid -> Mono.just((Object)entity));
            }
            return this.mongoOperations.save(entity, this.entityInformation.getCollectionName()).then(aVoid -> Mono.just((Object)entity));
        });
    }

    public Mono<Void> delete(ID id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        return this.mongoOperations.remove(this.getIdQuery(id), this.entityInformation.getJavaType(), this.entityInformation.getCollectionName()).then();
    }

    public Mono<Void> delete(T entity) {
        Assert.notNull(entity, (String)"The given entity must not be null!");
        return this.delete((T)((Serializable)this.entityInformation.getId(entity).get()));
    }

    public Mono<Void> delete(Iterable<? extends T> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities must not be null!");
        return Flux.fromIterable(entities).flatMap(entity -> this.delete((T)((Serializable)this.entityInformation.getId(entity).get()))).then();
    }

    public Mono<Void> delete(Publisher<? extends T> entityStream) {
        Assert.notNull(entityStream, (String)"The given Publisher of entities must not be null!");
        return Flux.from(entityStream).flatMap(entity -> this.delete((T)((Serializable)this.entityInformation.getId(entity).get()))).then();
    }

    public Mono<Void> deleteAll() {
        return this.mongoOperations.remove(new Query(), this.entityInformation.getCollectionName()).then(deleteResult -> Mono.empty());
    }

    private Query getIdQuery(Object id) {
        return new Query(this.getIdCriteria(id));
    }

    private Criteria getIdCriteria(Object id) {
        return Criteria.where(this.entityInformation.getIdAttribute()).is(id);
    }

    private Flux<T> findAll(Query query) {
        if (query == null) {
            return Flux.empty();
        }
        return this.mongoOperations.find(query, this.entityInformation.getJavaType(), this.entityInformation.getCollectionName());
    }

    private static <T> List<T> convertIterableToList(Iterable<T> entities) {
        if (entities instanceof List) {
            return (List)entities;
        }
        int capacity = SimpleReactiveMongoRepository.tryDetermineRealSizeOrReturn(entities, 10);
        if (capacity == 0 || entities == null) {
            return Collections.emptyList();
        }
        ArrayList<T> list = new ArrayList<T>(capacity);
        for (T entity : entities) {
            list.add(entity);
        }
        return list;
    }

    private static int tryDetermineRealSizeOrReturn(Iterable<?> iterable, int defaultSize) {
        return iterable == null ? 0 : (iterable instanceof Collection ? ((Collection)iterable).size() : defaultSize);
    }
}

